package com.mathworks;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;

/*
Dataset that is used, patients.csv is generated with the help of MATLAB. Please refer to https://www.mathworks.com/help/stats/generate-code-to-classify-data-in-table.html about patient dataset
*/
public class Utils {
    String fileName;

    Utils(String fileName) {
        this.fileName = fileName;
    }

    /**
     * Reads the csv file into an ArrayList for other methods to process accordingly
     *
     * @return ArrayList
     */

    public static ArrayList<String[]> readFromCsv() {
        Scanner sc = null;
        ArrayList<String[]> inputs = new ArrayList<String[]>();

        try {
            sc = new Scanner(new File("patients.csv"));

            sc.useDelimiter("\n");   //sets the delimiter pattern
            sc.next();
            String line;

            while (sc.hasNext())  //returns a boolean value
            {
                line = sc.next();
                StringTokenizer tokenizer = new StringTokenizer(line, ",");
                String[] tmp = new String[tokenizer.countTokens() - 1];
                for (int i = 0; i < tmp.length; i++) {
                    String s = tokenizer.nextToken();
                    if (s.compareTo("Inf") == 0) {
                        tmp[i] = String.valueOf(Double.POSITIVE_INFINITY);
                    } else if (s.compareTo("-Inf") == 0) {
                        tmp[i] = String.valueOf(Double.NEGATIVE_INFINITY);
                    } else {
                        tmp[i] = s;
                    }
                }
                inputs.add(tmp);
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }finally{
            sc.close();  //closes the scanner
        }

        return inputs;
    }



    /**
     * Reads the csv file prepares the data into {@link DataSet} DataSet array objects
     * as expected from the deployed MATLAB function
     *
     * @return DataSet[]
     */
    public static PatientData[] prepareDataForTableInput() {
        ArrayList<String[]> inputs = readFromCsv();
        int i = 0;
        PatientData[] datas = new PatientData[inputs.size()];
        for (String[] mat : inputs) {
            datas[i] = new PatientData(Double.valueOf(mat[0]),Double.valueOf(mat[1]),mat[2],Double.valueOf(mat[3]),mat[4] ,Double.valueOf(mat[5]),Double.valueOf(mat[6]));
            i++;
        }

        return datas;
    }

}