// Copyright 1984-2020 The MathWorks, Inc.
// All Rights Reserved.

using System;
using System.Net;
using MathWorks.MATLAB.ProductionServer.Client.REST;
using MathWorks.MATLAB.ProductionServer.Client;
using System.Collections.Generic;

namespace SortStudents
{
    class Student
    {
        public string name;
        private string gr;
        private int sc;

        public string grade
        {
            get { return gr; }
            set { gr = value; }
        }

        public int score
        {
            get { return sc; }
            set { sc = value; }
        }

        public override string ToString()
        {
            return name + " : " + grade + " : " + score;
        }


    }

    class StudentMarshaler : MWDefaultMarshalingRules
    {
        public override IList<Type> StructTypes
        {
            get
            {
                return new List<Type> { typeof(Student) };
            }
        }
    }
    public class SortStudentsSyncREST
    {
        static void Main(String[] args)
        {
            //Struct example for the new API.
            Student s1 = new Student();
            s1.name = "Tony Miller";
            s1.score = 90;
            s1.grade = "A";

            Student s2 = new Student();
            s2.name = "Ed Plum";
            s2.score = 80;
            s2.grade = "B+";

            Student s3 = new Student();
            s3.name = "Mark Jones";
            s3.score = 85;
            s3.grade = "A-";

            Student[] unsorted = new Student[] { s1, s2, s3 };

            // URL of the MATLAB Production Server.			
            String mpsBaseUrl = "http://localhost:9910";

            Console.WriteLine("Sending the POST request to the URL: " + mpsBaseUrl + "/sortstudents/sortstudents.");
            var firstRequest = (HttpWebRequest)WebRequest.Create(mpsBaseUrl + "/sortstudents/sortstudents");
            firstRequest.Method = "POST";

            //Set Content-Type HTTP header to protobuf.
            firstRequest.ContentType = "application/x-google-protobuf";

            //Use MATLABParams class to make POST request body.
            MATLABParams mlParams = MATLABParams.Create(1, new List<Type> { typeof(Student[]) }, new StudentMarshaler(), new object[] { unsorted });
            mlParams.WriteTo(firstRequest.GetRequestStream());
            var response = (HttpWebResponse)firstRequest.GetResponse();

            Console.WriteLine("The HTTP status code of the request is " + response.StatusCode + ". \n\n");

            //If there is a MATLAB error, call to Result<>() throws MATLABException which contains the error message displayed in MATLAB.
            Console.WriteLine("Parsing the result from the response of the HTTP Request using MATLABResult class.\n\n");
            MATLABResult mlResult;
            mlResult = MATLABResult.Create(mlParams, response.GetResponseStream());
            try
            {
                Student[] result = mlResult.Result<Student[]>();
                Console.WriteLine("Printing the sorted Student array...\n");
                PrintStudent(result);
            }
            catch (MATLABException e)
            {
                Console.WriteLine(e.ToString());
            }
            Console.ReadKey();


        }

        static void PrintStudent(Student[] students)
        {
            foreach (Student s in students)
            {
                Console.WriteLine(s.ToString());
            }

        }
    }
}
