﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//Dataset that is used is generated with the help of script generateData.m present in the example directory 
//It is dataset based off a linear equation
namespace ProdServerExamples
{
    class Utils
    {
        public static List<double[]> ReadFromCsv()
        {
            var fromCsv = new List<double[]>();
            using (var rd = new StreamReader("input.csv"))
            {
                rd.ReadLine();
                while (!rd.EndOfStream)
                {

                    var splits = rd.ReadLine().Split(',');
                    double[] row = new double[splits.Length];

                    for (int p = 0; p < splits.Length - 1; p++)
                    {
                        if (splits[p].CompareTo("Inf") == 0)
                        {
                            row[p] = double.PositiveInfinity;
                        }
                        else if (splits[p].CompareTo("-Inf") == 0)
                        {
                            row[p] = Double.NegativeInfinity;
                        }
                        else
                        {
                            row[p] = Convert.ToDouble(splits[p]);
                        }
                    }
                    fromCsv.Add(row);
                }
            }
            return fromCsv;
        }

        public static double[,] PrepareDataForMatrixInput()
        {
            List<double[]> fromCsv = ReadFromCsv();
            double[,] inputs = new double[fromCsv.Count,4];
            for(int i =0; i < fromCsv.Count;i++)
            {
                for(int j =0; j< 4; j++)
                {
                    inputs[i,j] = fromCsv[i][j];
                }
            }
            return inputs;
        }


    }
}
