﻿using System;
using System.Collections.Generic;
using System.IO;

namespace ProdServerExamples
{
	//Dataset that is used, patients.csv is generated with the help of MATLAB. Please refer to //https://www.mathworks.com/help/stats/generate-code-to-classify-data-in-table.html about patient dataset 

    class Utils
    {
		
		//Reads the csv file into an ArrayList for other methods to process accordingly
        public static List<String[]> ReadFromCsv()
        {
            var fromCsv = new List<String[]>();
            using (var rd = new StreamReader("patients.csv"))
            {
                rd.ReadLine();
                while (!rd.EndOfStream)
                {

                    var splits = rd.ReadLine().Split(',');
                    String[] row = new String[splits.Length];

                    for (int p = 0; p < splits.Length - 1; p++)
                    {
                            row[p] = splits[p];
                    }
                    fromCsv.Add(row);
                }
            }
            return fromCsv;
        }
		
		//Reads the csv file prepares the data into {@link DataSet} DataSet array objects
		// as expected from the deployed MATLAB function
        public static PatientData[] PrepareDataForTableInput()
        {
            List<String[]> fromCsv = ReadFromCsv();
            PatientData[] datas = new PatientData[fromCsv.Count];
            int i = 0;
            foreach (String[] mat in fromCsv)
            {
                datas[i] = new PatientData(Convert.ToDouble(mat[0]), Convert.ToDouble(mat[1]), mat[2], Convert.ToDouble(mat[3]), mat[4], Convert.ToDouble(mat[5]), Convert.ToDouble(mat[6]));
                i++;
            }

            return datas;
        }

    }
}
