function destinations = listDestinations()
% listDestinations List all destinations recorded in the graph.

% Copyright 1984-2019 The MathWorks, Inc.
% All Rights Reserved.

    % Connect to cache that contains the graph.
    c = mps.cache.connect('TravelingSalesman','Connection','ScratchPad');
    
    % If we can't load the distance data, we can't do any work. We may not
    % need to load the data, but if this is the first function any client
    % calls, we should.
    if loadDistanceData('ScratchPad','TravelingSalesman') == false
        error('Failed to load distance data. Cannot continue.');
    end
    
    % Get the graph, extract a table of nodes and turn it into a cell array
    % of strings.
    g = c.Distances;
    destinations = table2array(g.Nodes);
end