function result = predictFunction(varargin)
    %#function fitctree
    % result = predictFunction(varargin)   returns prediction results using the model trained in Regression Learner R2021b
    %
    %  Input:
    %      varargin: Input argument must be a matrix, whose 4 columns have the same order as the predictor variables that trained the deployed model.
    %  Output:
    %      result: Prediction results returned by the trained, deployed model

    % Auto-generated by MATLAB on 14-Jul-2021 15:41:33

    inputData = varargin{1};
    if ismatrix(inputData) && size(inputData,2) == 4
        T = inputData;

        % Uncomment the following lines of code if you used preprocessing
        % steps before importing data into Regression Learner. Add the
        % preprocessing steps to the processInputData.m file in the
        % RegressionLearnerDeployedModel_resources folder.

        % processedData = processInputData(T);
        % T = processedData;

    else
        error('stats:mlearnapp:DeployedModelError', 'Input argument must be a 4-column matrix.');
    end

    fileData = load('TrainedRegressionModel.mat');
    model = fileData.trainedModel;
    result = model.predictFcn(T);

end

