package com.mathworks;


import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.annotations.MWStructureList;

import java.io.IOException;
import java.net.URL;

interface CallMethod {
    @MWStructureList({PatientData.class})
    boolean[] predictFunction(PatientData[] dataSet) throws IOException, MATLABException;
}

public class PredictFunctionPatientData {

    public static void main(String[] args) {

        //Csv file is read and data is prepared as per the expected format
        PatientData[] datas = Utils.prepareDataForTableInput();

        // Create a non-interruptible MWHttpClient instance
        MWClient client = new MWHttpClient();
        try {
            // Create the proxy object that represents DeployedClassificationModel
            CallMethod s = client.createProxy(new URL("http://localhost:9910/DeployedClassificationModel"), CallMethod.class);

            // The proxy object has predictFunction as one of its public methods. Invocation of predictFunction
            // results in a server request that gets the results in response
            boolean[] results = s.predictFunction(datas);
            for (int j = 0; j < results.length; j++) {
                System.out.println(results[j]);
            }
        } catch (MATLABException ex) {

            // This exception represents errors in MATLAB and provides useful information
            // like the MATLAB stack trace or the error ID associated with this error.
            System.out.println(ex);
        } catch (IOException ex) {

            // This exception can represent network issues. It is also thrown when the
            // HTTP response received from the server has a status of 4XX or 5XX
            System.out.println(ex);
        } finally {

            // We should close the client when we know that we are not going to need it any more
            // Once the client is closed, an exception will be thrown if a MATLAB function is
            // invoked using the proxy object that was created using client.
            client.close();
        }
    }
}
