// Copyright 1984-2019 The MathWorks, Inc.
// All Rights Reserved.

import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWHttpClient;
import java.net.URL;

/**
 * Creates instance of the BondTools interface.
 */
public class ServerBondToolsFactory implements BondToolsFactory {

    private final MWClient client = new MWHttpClient();
    private String url;

    public ServerBondToolsFactory(String url){
        this.url = url;
    }

    public BondTools newInstance () throws Exception
    {
    	return client.createProxy(new URL(url), BondTools.class);
    }

    public void dispose ()
    {
        System.out.println("Closing MWClient...");
        client.close();
    }
}
