# Copyright 2014-2020 The MathWorks, Inc.
# All Rights Reserved.

import matlab
from production_server import client
from production_server import mpsexceptions
import sys

def main(size):
    # Create python client object. The default response timeout is 120 sec (2 mins).
    # Any custom response timeout should be specified in milliseconds.
    client_object = client.MWHttpClient('http://localhost:9910')
    
    try:                        
        # The CTF deployed on the server is magic.ctf. The MATLAB function is mymagic.
        # The MATLAB function is invoked using the python client object as below.   
        data = client_object.magic.mymagic(size)
        print(data)
        
    except mpsexceptions.MATLABException as e:
        print('MATLAB Error: ',e)
    finally:
        client_object.close()
        
if __name__ == '__main__':
    main(float(sys.argv[1]))
    