// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

#ifndef GOOGLE_PROTOBUF_PYTHON_CPP_UNKNOWN_FIELD_SET_H__
#define GOOGLE_PROTOBUF_PYTHON_CPP_UNKNOWN_FIELD_SET_H__

#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include <memory>
#include <set>

#include "google/protobuf_ml/pyext/message.h"

#include <google/protobuf_ml/port_def.inc> // Modified by MathWorks, 11/01/22: Wrapping Protobuf in extra 'inline namespace mathworks'

PROTOBUF_NAMESPACE_OPEN // Modified by MathWorks, 11/01/21: Wrapping Protobuf in extra 'inline namespace mathworks'

class UnknownField;
class UnknownFieldSet;

namespace python {
struct CMessage;

struct PyUnknownFieldSet {
  PyObject_HEAD;
  // If parent is nullptr, it is a top UnknownFieldSet.
  PyUnknownFieldSet* parent;

  // Top UnknownFieldSet owns fields pointer. Sub UnknownFieldSet
  // does not own fields pointer.
  UnknownFieldSet* fields;
};

struct PyUnknownField {
  PyObject_HEAD;
  // Every Python PyUnknownField holds a reference to its parent
  // PyUnknownFieldSet in order to keep it alive.
  PyUnknownFieldSet* parent;

  // The UnknownField index in UnknownFieldSet.
  Py_ssize_t index;
};

extern PyTypeObject PyUnknownFieldSet_Type;
extern PyTypeObject PyUnknownField_Type;

}  // namespace python
PROTOBUF_NAMESPACE_CLOSE // Modified by MathWorks, 11/01/21: Wrapping Protobuf in extra 'inline namespace mathworks'
#include <google/protobuf_ml/port_undef.inc> // Modified by MathWorks, 11/01/22: Wrapping Protobuf in extra 'inline namespace mathworks'

#endif  // GOOGLE_PROTOBUF_PYTHON_CPP_UNKNOWN_FIELD_SET_H__
