function price = pricecalc(value_at_maturity, coupon_payment,...
                           interest_rate, num_payments)
%% Following formula has been obtained from wikipedia: http://en.wikipedia.org/wiki/Bond_valuation

% Copyright 1984-2019 The MathWorks, Inc.
% All Rights Reserved.

    C = coupon_payment;
    N = num_payments;
    i = interest_rate;
    M = value_at_maturity;
    
    price = C * ( (1 - (1 + i)^-N) / i ) + M * (1 + i)^-N;

end
