/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.mps.client.MWRequestStateVisitor;
import com.mathworks.mps.client.internal.async.MWFuture;
import java.net.URL;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

class FutureVisitor<T>
implements MWRequestStateVisitor<T> {
    private MWFuture<T> future;

    public FutureVisitor(MWFuture<T> mWFuture) {
        this.future = mWFuture;
    }

    @Override
    public void cancelled() {
        this.setCancellationException("The request has been cancelled");
    }

    @Override
    public void expired() {
    }

    @Override
    public void failed(Exception exception) {
        this.setException(exception);
    }

    @Override
    public void interrupted() {
        this.setInterruptedException(new InterruptedException("The client has already been closed"));
    }

    @Override
    public void inQueue(long l, URL uRL) {
    }

    @Override
    public void processing(long l, URL uRL) {
        this.setStateToRunning();
    }

    @Override
    public void ready(T t) {
        this.setResult(t);
    }

    @Override
    public void sending(byte[] byArray, URL uRL) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setException(Exception exception) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setExecException(new ExecutionException(exception));
            this.future.finished = true;
            this.future.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancellationException(String string) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setCancelException(new CancellationException(string));
            this.future.finished = true;
            this.future.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterruptedException(InterruptedException interruptedException) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setInterruptedException(interruptedException);
            this.future.finished = true;
            this.future.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(T t) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.set(t);
            this.future.finished = true;
            this.future.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateToRunning() {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setState(0);
            this.future.lock.notify();
        }
    }
}

