/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import com.mathworks.mps.client.MATLABStackFrame;
import com.mathworks.mps.client.MWHttpClient;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class MATLABException
extends Exception {
    private final String message;
    private final String identifier;
    private final List<MATLABStackFrame> matlabStack;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MATLABException(String string, String string2, List<MATLABStackFrame> list) {
        if (list == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid MATLAB stack value : null");
            this.LOG.error("{}", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.message = string;
        this.identifier = string2;
        this.matlabStack = Collections.unmodifiableList(new ArrayList<MATLABStackFrame>(list));
        this.LOG.error("MATLABException - identifier: {} - message: {}", (Object)string2, (Object)string);
    }

    public List<MATLABStackFrame> getMATLABStackTrace() {
        return this.matlabStack;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getMATLABIdentifier() {
        return this.identifier;
    }

    public void printMATLABStackTrace() {
        this.printMATLABStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMATLABStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            this.printMATLABStackTrace(new PrintWriter(printStream, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMATLABStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            if (this.matlabStack.isEmpty()) {
                printWriter.println("<EMPTY MATLAB STACK>");
            } else {
                for (MATLABStackFrame mATLABStackFrame : this.matlabStack) {
                    printWriter.println(mATLABStackFrame);
                }
            }
        }
    }
}

