/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CanIgnoreReturnValue;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.CodedOutputStream;
import com.mathworks.google.protobuf.InvalidProtocolBufferException;
import com.mathworks.google.protobuf.MessageLiteToString;
import com.mathworks.google.protobuf.WireFormat;
import com.mathworks.google.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final int MIN_CAPACITY = 8;
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite unknownFieldSetLite, UnknownFieldSetLite unknownFieldSetLite2) {
        int n = unknownFieldSetLite.count + unknownFieldSetLite2.count;
        int[] nArray = Arrays.copyOf(unknownFieldSetLite.tags, n);
        System.arraycopy(unknownFieldSetLite2.tags, 0, nArray, unknownFieldSetLite.count, unknownFieldSetLite2.count);
        Object[] objectArray = Arrays.copyOf(unknownFieldSetLite.objects, n);
        System.arraycopy(unknownFieldSetLite2.objects, 0, objectArray, unknownFieldSetLite.count, unknownFieldSetLite2.count);
        return new UnknownFieldSetLite(n, nArray, objectArray, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    private UnknownFieldSetLite(int n, int[] nArray, Object[] objectArray, boolean bl) {
        this.count = n;
        this.tags = nArray;
        this.objects = objectArray;
        this.isMutable = bl;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        block7: for (int i = 0; i < this.count; ++i) {
            int n = this.tags[i];
            int n2 = WireFormat.getTagFieldNumber(n);
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    codedOutputStream.writeUInt64(n2, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    codedOutputStream.writeFixed32(n2, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    codedOutputStream.writeFixed64(n2, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    codedOutputStream.writeBytes(n2, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    codedOutputStream.writeTag(n2, 3);
                    ((UnknownFieldSetLite)this.objects[i]).writeTo(codedOutputStream);
                    codedOutputStream.writeTag(n2, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    public void writeAsMessageSetTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            int n = WireFormat.getTagFieldNumber(this.tags[i]);
            codedOutputStream.writeRawMessageSetExtension(n, (ByteString)this.objects[i]);
        }
    }

    void writeAsMessageSetTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (int i = this.count - 1; i >= 0; --i) {
                int n = WireFormat.getTagFieldNumber(this.tags[i]);
                writer.writeMessageSetItem(n, this.objects[i]);
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                int n = WireFormat.getTagFieldNumber(this.tags[i]);
                writer.writeMessageSetItem(n, this.objects[i]);
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
            for (int i = 0; i < this.count; ++i) {
                UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
            }
        } else {
            for (int i = this.count - 1; i >= 0; --i) {
                UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
            }
        }
    }

    private static void writeField(int n, Object object, Writer writer) throws IOException {
        int n2 = WireFormat.getTagFieldNumber(n);
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                writer.writeInt64(n2, (Long)object);
                break;
            }
            case 5: {
                writer.writeFixed32(n2, (Integer)object);
                break;
            }
            case 1: {
                writer.writeFixed64(n2, (Long)object);
                break;
            }
            case 2: {
                writer.writeBytes(n2, (ByteString)object);
                break;
            }
            case 3: {
                if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                    writer.writeStartGroup(n2);
                    ((UnknownFieldSetLite)object).writeTo(writer);
                    writer.writeEndGroup(n2);
                    break;
                }
                writer.writeEndGroup(n2);
                ((UnknownFieldSetLite)object).writeTo(writer);
                writer.writeStartGroup(n2);
                break;
            }
            default: {
                throw new RuntimeException(InvalidProtocolBufferException.invalidWireType());
            }
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int n = this.memoizedSerializedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        for (int i = 0; i < this.count; ++i) {
            int n2 = this.tags[i];
            int n3 = WireFormat.getTagFieldNumber(n2);
            n += CodedOutputStream.computeRawMessageSetExtensionSize(n3, (ByteString)this.objects[i]);
        }
        this.memoizedSerializedSize = n;
        return n;
    }

    public int getSerializedSize() {
        int n = this.memoizedSerializedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        block7: for (int i = 0; i < this.count; ++i) {
            int n2 = this.tags[i];
            int n3 = WireFormat.getTagFieldNumber(n2);
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    n += CodedOutputStream.computeUInt64Size(n3, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    n += CodedOutputStream.computeFixed32Size(n3, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    n += CodedOutputStream.computeFixed64Size(n3, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    n += CodedOutputStream.computeBytesSize(n3, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    n += CodedOutputStream.computeTagSize(n3) * 2 + ((UnknownFieldSetLite)this.objects[i]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = n;
        return n;
    }

    private static boolean tagsEquals(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean objectsEquals(Object[] objectArray, Object[] objectArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite unknownFieldSetLite = (UnknownFieldSetLite)object;
        return this.count == unknownFieldSetLite.count && UnknownFieldSetLite.tagsEquals(this.tags, unknownFieldSetLite.tags, this.count) && UnknownFieldSetLite.objectsEquals(this.objects, unknownFieldSetLite.objects, this.count);
    }

    private static int hashCode(int[] nArray, int n) {
        int n2 = 17;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + nArray[i];
        }
        return n2;
    }

    private static int hashCode(Object[] objectArray, int n) {
        int n2 = 17;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + objectArray[i].hashCode();
        }
        return n2;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.count;
        n = 31 * n + UnknownFieldSetLite.hashCode(this.tags, this.count);
        n = 31 * n + UnknownFieldSetLite.hashCode(this.objects, this.count);
        return n;
    }

    final void printWithIndent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < this.count; ++i) {
            int n2 = WireFormat.getTagFieldNumber(this.tags[i]);
            MessageLiteToString.printField(stringBuilder, n, String.valueOf(n2), this.objects[i]);
        }
    }

    void storeField(int n, Object object) {
        this.checkMutable();
        this.ensureCapacity(this.count + 1);
        this.tags[this.count] = n;
        this.objects[this.count] = object;
        ++this.count;
    }

    private void ensureCapacity(int n) {
        if (n > this.tags.length) {
            int n2 = this.count + this.count / 2;
            if (n2 < n) {
                n2 = n;
            }
            if (n2 < 8) {
                n2 = 8;
            }
            this.tags = Arrays.copyOf(this.tags, n2);
            this.objects = Arrays.copyOf(this.objects, n2);
        }
    }

    boolean mergeFieldFrom(int n, CodedInputStream codedInputStream) throws IOException {
        this.checkMutable();
        int n2 = WireFormat.getTagFieldNumber(n);
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.storeField(n, codedInputStream.readInt64());
                return true;
            }
            case 5: {
                this.storeField(n, codedInputStream.readFixed32());
                return true;
            }
            case 1: {
                this.storeField(n, codedInputStream.readFixed64());
                return true;
            }
            case 2: {
                this.storeField(n, codedInputStream.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetLite unknownFieldSetLite = new UnknownFieldSetLite();
                unknownFieldSetLite.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(WireFormat.makeTag(n2, 4));
                this.storeField(n, unknownFieldSetLite);
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    UnknownFieldSetLite mergeVarintField(int n, int n2) {
        this.checkMutable();
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(n, 0), n2);
        return this;
    }

    UnknownFieldSetLite mergeLengthDelimitedField(int n, ByteString byteString) {
        this.checkMutable();
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(n, 2), byteString);
        return this;
    }

    private UnknownFieldSetLite mergeFrom(CodedInputStream codedInputStream) throws IOException {
        int n;
        while ((n = codedInputStream.readTag()) != 0 && this.mergeFieldFrom(n, codedInputStream)) {
        }
        return this;
    }

    @CanIgnoreReturnValue
    UnknownFieldSetLite mergeFrom(UnknownFieldSetLite unknownFieldSetLite) {
        if (unknownFieldSetLite.equals(UnknownFieldSetLite.getDefaultInstance())) {
            return this;
        }
        this.checkMutable();
        int n = this.count + unknownFieldSetLite.count;
        this.ensureCapacity(n);
        System.arraycopy(unknownFieldSetLite.tags, 0, this.tags, this.count, unknownFieldSetLite.count);
        System.arraycopy(unknownFieldSetLite.objects, 0, this.objects, this.count, unknownFieldSetLite.count);
        this.count = n;
        return this;
    }
}

