/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.AbstractMessageLite;
import com.mathworks.google.protobuf.AbstractParser;
import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.CodedOutputStream;
import com.mathworks.google.protobuf.ExtensionRegistry;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.google.protobuf.InvalidProtocolBufferException;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.TextFormat;
import com.mathworks.google.protobuf.WireFormat;
import com.mathworks.google.protobuf.Writer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public final class UnknownFieldSet
implements MessageLite {
    private final TreeMap<Integer, Field> fields;
    private static final UnknownFieldSet defaultInstance = new UnknownFieldSet(new TreeMap<Integer, Field>());
    private static final Parser PARSER = new Parser();

    private UnknownFieldSet(TreeMap<Integer, Field> treeMap) {
        this.fields = treeMap;
    }

    public static Builder newBuilder() {
        return Builder.create();
    }

    public static Builder newBuilder(UnknownFieldSet unknownFieldSet) {
        return UnknownFieldSet.newBuilder().mergeFrom(unknownFieldSet);
    }

    public static UnknownFieldSet getDefaultInstance() {
        return defaultInstance;
    }

    @Override
    public UnknownFieldSet getDefaultInstanceForType() {
        return defaultInstance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof UnknownFieldSet && this.fields.equals(((UnknownFieldSet)object).fields);
    }

    public int hashCode() {
        if (this.fields.isEmpty()) {
            return 0;
        }
        return this.fields.hashCode();
    }

    public Map<Integer, Field> asMap() {
        return (Map)this.fields.clone();
    }

    public boolean hasField(int n) {
        return this.fields.containsKey(n);
    }

    public Field getField(int n) {
        Field field = this.fields.get(n);
        return field == null ? Field.getDefaultInstance() : field;
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            Field field = entry.getValue();
            field.writeTo((int)entry.getKey(), codedOutputStream);
        }
    }

    public String toString() {
        return TextFormat.printer().printToString(this);
    }

    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(codedBuilder.getCodedOutput());
            return codedBuilder.build();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] byArray = new byte[this.getSerializedSize()];
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byArray);
            this.writeTo(codedOutputStream);
            codedOutputStream.checkNoSpaceLeft();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public void writeDelimitedTo(OutputStream outputStream) throws IOException {
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream);
        codedOutputStream.writeUInt32NoTag(this.getSerializedSize());
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public int getSerializedSize() {
        int n = 0;
        if (!this.fields.isEmpty()) {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                n += entry.getValue().getSerializedSize(entry.getKey());
            }
        }
        return n;
    }

    public void writeAsMessageSetTo(CodedOutputStream codedOutputStream) throws IOException {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            entry.getValue().writeAsMessageSetExtensionTo((int)entry.getKey(), codedOutputStream);
        }
    }

    void writeTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (Map.Entry entry : this.fields.descendingMap().entrySet()) {
                ((Field)entry.getValue()).writeTo((int)((Integer)entry.getKey()), writer);
            }
        } else {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                entry.getValue().writeTo((int)entry.getKey(), writer);
            }
        }
    }

    void writeAsMessageSetTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (Map.Entry entry : this.fields.descendingMap().entrySet()) {
                ((Field)entry.getValue()).writeAsMessageSetExtensionTo((Integer)entry.getKey(), writer);
            }
        } else {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                entry.getValue().writeAsMessageSetExtensionTo(entry.getKey(), writer);
            }
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int n = 0;
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            n += entry.getValue().getSerializedSizeAsMessageSetExtension(entry.getKey());
        }
        return n;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    public static UnknownFieldSet parseFrom(CodedInputStream codedInputStream) throws IOException {
        return UnknownFieldSet.newBuilder().mergeFrom(codedInputStream).build();
    }

    public static UnknownFieldSet parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return UnknownFieldSet.newBuilder().mergeFrom(byteString).build();
    }

    public static UnknownFieldSet parseFrom(byte[] byArray) throws InvalidProtocolBufferException {
        return UnknownFieldSet.newBuilder().mergeFrom(byArray).build();
    }

    public static UnknownFieldSet parseFrom(InputStream inputStream) throws IOException {
        return UnknownFieldSet.newBuilder().mergeFrom(inputStream).build();
    }

    @Override
    public Builder newBuilderForType() {
        return UnknownFieldSet.newBuilder();
    }

    @Override
    public Builder toBuilder() {
        return UnknownFieldSet.newBuilder().mergeFrom(this);
    }

    public final Parser getParserForType() {
        return PARSER;
    }

    public static final class Parser
    extends AbstractParser<UnknownFieldSet> {
        @Override
        public UnknownFieldSet parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            Builder builder = UnknownFieldSet.newBuilder();
            try {
                builder.mergeFrom(codedInputStream);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException iOException) {
                throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    }

    public static final class Field {
        private static final Field fieldDefaultInstance = Field.newBuilder().build();
        private List<Long> varint;
        private List<Integer> fixed32;
        private List<Long> fixed64;
        private List<ByteString> lengthDelimited;
        private List<UnknownFieldSet> group;

        private Field() {
        }

        public static Builder newBuilder() {
            return Builder.create();
        }

        public static Builder newBuilder(Field field) {
            return Field.newBuilder().mergeFrom(field);
        }

        public static Field getDefaultInstance() {
            return fieldDefaultInstance;
        }

        public List<Long> getVarintList() {
            return this.varint;
        }

        public List<Integer> getFixed32List() {
            return this.fixed32;
        }

        public List<Long> getFixed64List() {
            return this.fixed64;
        }

        public List<ByteString> getLengthDelimitedList() {
            return this.lengthDelimited;
        }

        public List<UnknownFieldSet> getGroupList() {
            return this.group;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Field)) {
                return false;
            }
            return Arrays.equals(this.getIdentityArray(), ((Field)object).getIdentityArray());
        }

        public int hashCode() {
            return Arrays.hashCode(this.getIdentityArray());
        }

        private Object[] getIdentityArray() {
            return new Object[]{this.varint, this.fixed32, this.fixed64, this.lengthDelimited, this.group};
        }

        public ByteString toByteString(int n) {
            try {
                ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(this.getSerializedSize(n));
                this.writeTo(n, codedBuilder.getCodedOutput());
                return codedBuilder.build();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Serializing to a ByteString should never fail with an IOException", iOException);
            }
        }

        public void writeTo(int n, CodedOutputStream codedOutputStream) throws IOException {
            long l;
            Iterator<Object> iterator = this.varint.iterator();
            while (iterator.hasNext()) {
                l = iterator.next();
                codedOutputStream.writeUInt64(n, l);
            }
            iterator = this.fixed32.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                codedOutputStream.writeFixed32(n, n2);
            }
            iterator = this.fixed64.iterator();
            while (iterator.hasNext()) {
                l = (Long)iterator.next();
                codedOutputStream.writeFixed64(n, l);
            }
            for (ByteString byteString : this.lengthDelimited) {
                codedOutputStream.writeBytes(n, byteString);
            }
            for (UnknownFieldSet unknownFieldSet : this.group) {
                codedOutputStream.writeGroup(n, unknownFieldSet);
            }
        }

        public int getSerializedSize(int n) {
            long l;
            int n2 = 0;
            Iterator<Object> iterator = this.varint.iterator();
            while (iterator.hasNext()) {
                l = iterator.next();
                n2 += CodedOutputStream.computeUInt64Size(n, l);
            }
            iterator = this.fixed32.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                n2 += CodedOutputStream.computeFixed32Size(n, n3);
            }
            iterator = this.fixed64.iterator();
            while (iterator.hasNext()) {
                l = (Long)iterator.next();
                n2 += CodedOutputStream.computeFixed64Size(n, l);
            }
            for (ByteString byteString : this.lengthDelimited) {
                n2 += CodedOutputStream.computeBytesSize(n, byteString);
            }
            for (UnknownFieldSet unknownFieldSet : this.group) {
                n2 += CodedOutputStream.computeGroupSize(n, unknownFieldSet);
            }
            return n2;
        }

        public void writeAsMessageSetExtensionTo(int n, CodedOutputStream codedOutputStream) throws IOException {
            for (ByteString byteString : this.lengthDelimited) {
                codedOutputStream.writeRawMessageSetExtension(n, byteString);
            }
        }

        void writeTo(int n, Writer writer) throws IOException {
            writer.writeInt64List(n, this.varint, false);
            writer.writeFixed32List(n, this.fixed32, false);
            writer.writeFixed64List(n, this.fixed64, false);
            writer.writeBytesList(n, this.lengthDelimited);
            if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                for (int i = 0; i < this.group.size(); ++i) {
                    writer.writeStartGroup(n);
                    this.group.get(i).writeTo(writer);
                    writer.writeEndGroup(n);
                }
            } else {
                for (int i = this.group.size() - 1; i >= 0; --i) {
                    writer.writeEndGroup(n);
                    this.group.get(i).writeTo(writer);
                    writer.writeStartGroup(n);
                }
            }
        }

        private void writeAsMessageSetExtensionTo(int n, Writer writer) throws IOException {
            if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
                ListIterator<ByteString> listIterator = this.lengthDelimited.listIterator(this.lengthDelimited.size());
                while (listIterator.hasPrevious()) {
                    writer.writeMessageSetItem(n, listIterator.previous());
                }
            } else {
                for (ByteString byteString : this.lengthDelimited) {
                    writer.writeMessageSetItem(n, byteString);
                }
            }
        }

        public int getSerializedSizeAsMessageSetExtension(int n) {
            int n2 = 0;
            for (ByteString byteString : this.lengthDelimited) {
                n2 += CodedOutputStream.computeRawMessageSetExtensionSize(n, byteString);
            }
            return n2;
        }

        public static final class Builder {
            private Field result = new Field();

            private Builder() {
            }

            private static Builder create() {
                Builder builder = new Builder();
                return builder;
            }

            public Builder clone() {
                Field field = new Field();
                if (this.result.varint == null) {
                    field.varint = null;
                } else {
                    field.varint = new ArrayList(this.result.varint);
                }
                if (this.result.fixed32 == null) {
                    field.fixed32 = null;
                } else {
                    field.fixed32 = new ArrayList(this.result.fixed32);
                }
                if (this.result.fixed64 == null) {
                    field.fixed64 = null;
                } else {
                    field.fixed64 = new ArrayList(this.result.fixed64);
                }
                if (this.result.lengthDelimited == null) {
                    field.lengthDelimited = null;
                } else {
                    field.lengthDelimited = new ArrayList(this.result.lengthDelimited);
                }
                if (this.result.group == null) {
                    field.group = null;
                } else {
                    field.group = new ArrayList(this.result.group);
                }
                Builder builder = new Builder();
                builder.result = field;
                return builder;
            }

            public Field build() {
                Field field = new Field();
                if (this.result.varint == null) {
                    field.varint = Collections.emptyList();
                } else {
                    field.varint = Collections.unmodifiableList(new ArrayList(this.result.varint));
                }
                if (this.result.fixed32 == null) {
                    field.fixed32 = Collections.emptyList();
                } else {
                    field.fixed32 = Collections.unmodifiableList(new ArrayList(this.result.fixed32));
                }
                if (this.result.fixed64 == null) {
                    field.fixed64 = Collections.emptyList();
                } else {
                    field.fixed64 = Collections.unmodifiableList(new ArrayList(this.result.fixed64));
                }
                if (this.result.lengthDelimited == null) {
                    field.lengthDelimited = Collections.emptyList();
                } else {
                    field.lengthDelimited = Collections.unmodifiableList(new ArrayList(this.result.lengthDelimited));
                }
                if (this.result.group == null) {
                    field.group = Collections.emptyList();
                } else {
                    field.group = Collections.unmodifiableList(new ArrayList(this.result.group));
                }
                return field;
            }

            public Builder clear() {
                this.result = new Field();
                return this;
            }

            public Builder mergeFrom(Field field) {
                if (!field.varint.isEmpty()) {
                    if (this.result.varint == null) {
                        this.result.varint = new ArrayList();
                    }
                    this.result.varint.addAll(field.varint);
                }
                if (!field.fixed32.isEmpty()) {
                    if (this.result.fixed32 == null) {
                        this.result.fixed32 = new ArrayList();
                    }
                    this.result.fixed32.addAll(field.fixed32);
                }
                if (!field.fixed64.isEmpty()) {
                    if (this.result.fixed64 == null) {
                        this.result.fixed64 = new ArrayList();
                    }
                    this.result.fixed64.addAll(field.fixed64);
                }
                if (!field.lengthDelimited.isEmpty()) {
                    if (this.result.lengthDelimited == null) {
                        this.result.lengthDelimited = new ArrayList();
                    }
                    this.result.lengthDelimited.addAll(field.lengthDelimited);
                }
                if (!field.group.isEmpty()) {
                    if (this.result.group == null) {
                        this.result.group = new ArrayList();
                    }
                    this.result.group.addAll(field.group);
                }
                return this;
            }

            public Builder addVarint(long l) {
                if (this.result.varint == null) {
                    this.result.varint = new ArrayList();
                }
                this.result.varint.add(l);
                return this;
            }

            public Builder addFixed32(int n) {
                if (this.result.fixed32 == null) {
                    this.result.fixed32 = new ArrayList();
                }
                this.result.fixed32.add(n);
                return this;
            }

            public Builder addFixed64(long l) {
                if (this.result.fixed64 == null) {
                    this.result.fixed64 = new ArrayList();
                }
                this.result.fixed64.add(l);
                return this;
            }

            public Builder addLengthDelimited(ByteString byteString) {
                if (this.result.lengthDelimited == null) {
                    this.result.lengthDelimited = new ArrayList();
                }
                this.result.lengthDelimited.add(byteString);
                return this;
            }

            public Builder addGroup(UnknownFieldSet unknownFieldSet) {
                if (this.result.group == null) {
                    this.result.group = new ArrayList();
                }
                this.result.group.add(unknownFieldSet);
                return this;
            }
        }
    }

    public static final class Builder
    implements MessageLite.Builder {
        private TreeMap<Integer, Field.Builder> fieldBuilders = new TreeMap();

        private Builder() {
        }

        private static Builder create() {
            return new Builder();
        }

        private Field.Builder getFieldBuilder(int n) {
            if (n == 0) {
                return null;
            }
            Field.Builder builder = this.fieldBuilders.get(n);
            if (builder == null) {
                builder = Field.newBuilder();
                this.fieldBuilders.put(n, builder);
            }
            return builder;
        }

        @Override
        public UnknownFieldSet build() {
            UnknownFieldSet unknownFieldSet;
            if (this.fieldBuilders.isEmpty()) {
                unknownFieldSet = UnknownFieldSet.getDefaultInstance();
            } else {
                TreeMap<Integer, Field> treeMap = new TreeMap<Integer, Field>();
                for (Map.Entry<Integer, Field.Builder> entry : this.fieldBuilders.entrySet()) {
                    treeMap.put(entry.getKey(), entry.getValue().build());
                }
                unknownFieldSet = new UnknownFieldSet(treeMap);
            }
            return unknownFieldSet;
        }

        @Override
        public UnknownFieldSet buildPartial() {
            return this.build();
        }

        @Override
        public Builder clone() {
            Builder builder = UnknownFieldSet.newBuilder();
            for (Map.Entry<Integer, Field.Builder> entry : this.fieldBuilders.entrySet()) {
                Integer n = entry.getKey();
                Field.Builder builder2 = entry.getValue();
                builder.fieldBuilders.put(n, builder2.clone());
            }
            return builder;
        }

        @Override
        public UnknownFieldSet getDefaultInstanceForType() {
            return UnknownFieldSet.getDefaultInstance();
        }

        @Override
        public Builder clear() {
            this.fieldBuilders = new TreeMap();
            return this;
        }

        public Builder clearField(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException(n + " is not a valid field number.");
            }
            if (this.fieldBuilders.containsKey(n)) {
                this.fieldBuilders.remove(n);
            }
            return this;
        }

        public Builder mergeFrom(UnknownFieldSet unknownFieldSet) {
            if (unknownFieldSet != UnknownFieldSet.getDefaultInstance()) {
                for (Map.Entry entry : unknownFieldSet.fields.entrySet()) {
                    this.mergeField((Integer)entry.getKey(), (Field)entry.getValue());
                }
            }
            return this;
        }

        public Builder mergeField(int n, Field field) {
            if (n <= 0) {
                throw new IllegalArgumentException(n + " is not a valid field number.");
            }
            if (this.hasField(n)) {
                this.getFieldBuilder(n).mergeFrom(field);
            } else {
                this.addField(n, field);
            }
            return this;
        }

        public Builder mergeVarintField(int n, int n2) {
            if (n <= 0) {
                throw new IllegalArgumentException(n + " is not a valid field number.");
            }
            this.getFieldBuilder(n).addVarint(n2);
            return this;
        }

        public Builder mergeLengthDelimitedField(int n, ByteString byteString) {
            if (n <= 0) {
                throw new IllegalArgumentException(n + " is not a valid field number.");
            }
            this.getFieldBuilder(n).addLengthDelimited(byteString);
            return this;
        }

        public boolean hasField(int n) {
            return this.fieldBuilders.containsKey(n);
        }

        public Builder addField(int n, Field field) {
            if (n <= 0) {
                throw new IllegalArgumentException(n + " is not a valid field number.");
            }
            this.fieldBuilders.put(n, Field.newBuilder(field));
            return this;
        }

        public Map<Integer, Field> asMap() {
            TreeMap<Integer, Field> treeMap = new TreeMap<Integer, Field>();
            for (Map.Entry<Integer, Field.Builder> entry : this.fieldBuilders.entrySet()) {
                treeMap.put(entry.getKey(), entry.getValue().build());
            }
            return Collections.unmodifiableMap(treeMap);
        }

        @Override
        public Builder mergeFrom(CodedInputStream codedInputStream) throws IOException {
            int n;
            while ((n = codedInputStream.readTag()) != 0 && this.mergeFieldFrom(n, codedInputStream)) {
            }
            return this;
        }

        public boolean mergeFieldFrom(int n, CodedInputStream codedInputStream) throws IOException {
            int n2 = WireFormat.getTagFieldNumber(n);
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    this.getFieldBuilder(n2).addVarint(codedInputStream.readInt64());
                    return true;
                }
                case 1: {
                    this.getFieldBuilder(n2).addFixed64(codedInputStream.readFixed64());
                    return true;
                }
                case 2: {
                    this.getFieldBuilder(n2).addLengthDelimited(codedInputStream.readBytes());
                    return true;
                }
                case 3: {
                    Builder builder = UnknownFieldSet.newBuilder();
                    codedInputStream.readGroup(n2, builder, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                    this.getFieldBuilder(n2).addGroup(builder.build());
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.getFieldBuilder(n2).addFixed32(codedInputStream.readFixed32());
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public Builder mergeFrom(ByteString byteString) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = byteString.newCodedInput();
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", iOException);
            }
        }

        @Override
        public Builder mergeFrom(byte[] byArray) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
            }
        }

        @Override
        public Builder mergeFrom(InputStream inputStream) throws IOException {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return this;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                return false;
            }
            int n2 = CodedInputStream.readRawVarint32(n, inputStream);
            AbstractMessageLite.Builder.LimitedInputStream limitedInputStream = new AbstractMessageLite.Builder.LimitedInputStream(inputStream, n2);
            this.mergeFrom(limitedInputStream);
            return true;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return this.mergeDelimitedFrom(inputStream);
        }

        @Override
        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return this.mergeFrom(codedInputStream);
        }

        @Override
        public Builder mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return this.mergeFrom(byteString);
        }

        @Override
        public Builder mergeFrom(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
            }
        }

        @Override
        public Builder mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return this.mergeFrom(byArray);
        }

        @Override
        public Builder mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return this.mergeFrom(byArray, n, n2);
        }

        @Override
        public Builder mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return this.mergeFrom(inputStream);
        }

        @Override
        public Builder mergeFrom(MessageLite messageLite) {
            if (messageLite instanceof UnknownFieldSet) {
                return this.mergeFrom((UnknownFieldSet)messageLite);
            }
            throw new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
        }

        @Override
        public boolean isInitialized() {
            return true;
        }
    }
}

