/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import java.util.Arrays;

public final class TextFormatParseLocation {
    public static final TextFormatParseLocation EMPTY = new TextFormatParseLocation(-1, -1);
    private final int line;
    private final int column;

    static TextFormatParseLocation create(int n, int n2) {
        if (n == -1 && n2 == -1) {
            return EMPTY;
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(String.format("line and column values must be >= 0: line %d, column: %d", n, n2));
        }
        return new TextFormatParseLocation(n, n2);
    }

    private TextFormatParseLocation(int n, int n2) {
        this.line = n;
        this.column = n2;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return String.format("ParseLocation{line=%d, column=%d}", this.line, this.column);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextFormatParseLocation)) {
            return false;
        }
        TextFormatParseLocation textFormatParseLocation = (TextFormatParseLocation)object;
        return this.line == textFormatParseLocation.getLine() && this.column == textFormatParseLocation.getColumn();
    }

    public int hashCode() {
        int[] nArray = new int[]{this.line, this.column};
        return Arrays.hashCode(nArray);
    }
}

