/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.AbstractProtobufList;
import java.util.Arrays;
import java.util.RandomAccess;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E>
implements RandomAccess {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList<Object>(new Object[0], 0, false);
    private E[] array;
    private int size;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new Object[10], 0, true);
    }

    private ProtobufArrayList(E[] EArray, int n, boolean bl) {
        super(bl);
        this.array = EArray;
        this.size = n;
    }

    @Override
    public ProtobufArrayList<E> mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        E[] EArray = Arrays.copyOf(this.array, n);
        return new ProtobufArrayList<E>(EArray, this.size, true);
    }

    @Override
    public boolean add(E e) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n = this.size * 3 / 2 + 1;
            E[] EArray = Arrays.copyOf(this.array, n);
            this.array = EArray;
        }
        this.array[this.size++] = e;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            E[] EArray = ProtobufArrayList.createArray(n2);
            System.arraycopy(this.array, 0, EArray, 0, n);
            System.arraycopy(this.array, n, EArray, n + 1, this.size - n);
            this.array = EArray;
        }
        this.array[n] = e;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E get(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public E remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        E e = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    @Override
    public E set(int n, E e) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        E e2 = this.array[n];
        this.array[n] = e;
        ++this.modCount;
        return e2;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static <E> E[] createArray(int n) {
        return new Object[n];
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        return "Index:" + n + ", Size:" + this.size;
    }
}

