/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.AbstractProtobufList;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class IntArrayList
extends AbstractProtobufList<Integer>
implements Internal.IntList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final IntArrayList EMPTY_LIST = new IntArrayList(new int[0], 0, false);
    private int[] array;
    private int size;

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    IntArrayList() {
        this(new int[10], 0, true);
    }

    private IntArrayList(int[] nArray, int n, boolean bl) {
        super(bl);
        this.array = nArray;
        this.size = n;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.ensureIsMutable();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n2, this.array, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntArrayList)) {
            return super.equals(object);
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (this.size != intArrayList.size) {
            return false;
        }
        int[] nArray = intArrayList.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.array[i];
        }
        return n;
    }

    @Override
    public Internal.IntList mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new IntArrayList(Arrays.copyOf(this.array, n), this.size, true);
    }

    @Override
    public Integer get(int n) {
        return this.getInt(n);
    }

    @Override
    public int getInt(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.array[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Integer set(int n, Integer n2) {
        return this.setInt(n, n2);
    }

    @Override
    public int setInt(int n, int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        int n3 = this.array[n];
        this.array[n] = n2;
        return n3;
    }

    @Override
    public boolean add(Integer n) {
        this.addInt(n);
        return true;
    }

    @Override
    public void add(int n, Integer n2) {
        this.addInt(n, n2);
    }

    @Override
    public void addInt(int n) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n2];
            System.arraycopy(this.array, 0, nArray, 0, this.size);
            this.array = nArray;
        }
        this.array[this.size++] = n;
    }

    private void addInt(int n, int n2) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n3 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n3];
            System.arraycopy(this.array, 0, nArray, 0, n);
            System.arraycopy(this.array, n, nArray, n + 1, this.size - n);
            this.array = nArray;
        }
        this.array[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof IntArrayList)) {
            return super.addAll(collection);
        }
        IntArrayList intArrayList = (IntArrayList)collection;
        if (intArrayList.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < intArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n2 = this.size + intArrayList.size;
        if (n2 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n2);
        }
        System.arraycopy(intArrayList.array, 0, this.array, this.size, intArrayList.size);
        this.size = n2;
        ++this.modCount;
        return true;
    }

    @Override
    public Integer remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        int n2 = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        }
        --this.size;
        ++this.modCount;
        return n2;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        return "Index:" + n + ", Size:" + this.size;
    }
}

