/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CodedInputStreamReader;
import com.mathworks.google.protobuf.CodedOutputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.InvalidProtocolBufferException;
import com.mathworks.google.protobuf.IterableByteBufferInputStream;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.Parser;
import com.mathworks.google.protobuf.UnsafeUtil;
import com.mathworks.google.protobuf.Utf8;
import com.mathworks.google.protobuf.WireFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CodedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_SIZE_LIMIT = Integer.MAX_VALUE;
    private static volatile int defaultRecursionLimit = 100;
    int recursionDepth;
    int recursionLimit = defaultRecursionLimit;
    int sizeLimit = Integer.MAX_VALUE;
    CodedInputStreamReader wrapper;
    private boolean shouldDiscardUnknownFields = false;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return CodedInputStream.newInstance(inputStream, 4096);
    }

    public static CodedInputStream newInstance(InputStream inputStream, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("bufferSize must be > 0");
        }
        if (inputStream == null) {
            return CodedInputStream.newInstance(Internal.EMPTY_BYTE_ARRAY);
        }
        return new StreamDecoder(inputStream, n);
    }

    public static CodedInputStream newInstance(Iterable<ByteBuffer> iterable) {
        if (!UnsafeDirectNioDecoder.isSupported()) {
            return CodedInputStream.newInstance(new IterableByteBufferInputStream(iterable));
        }
        return CodedInputStream.newInstance(iterable, false);
    }

    static CodedInputStream newInstance(Iterable<ByteBuffer> iterable, boolean bl) {
        int n = 0;
        int n2 = 0;
        for (ByteBuffer byteBuffer : iterable) {
            n2 += byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                n |= 1;
                continue;
            }
            if (byteBuffer.isDirect()) {
                n |= 2;
                continue;
            }
            n |= 4;
        }
        if (n == 2) {
            return new IterableDirectByteBufferDecoder(iterable, n2, bl);
        }
        return CodedInputStream.newInstance(new IterableByteBufferInputStream(iterable));
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputStream newInstance(byte[] byArray, int n, int n2) {
        return CodedInputStream.newInstance(byArray, n, n2, false);
    }

    static CodedInputStream newInstance(byte[] byArray, int n, int n2, boolean bl) {
        ArrayDecoder arrayDecoder = new ArrayDecoder(byArray, n, n2, bl);
        try {
            arrayDecoder.pushLimit(n2);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return arrayDecoder;
    }

    public static CodedInputStream newInstance(ByteBuffer byteBuffer) {
        return CodedInputStream.newInstance(byteBuffer, false);
    }

    static CodedInputStream newInstance(ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer.hasArray()) {
            return CodedInputStream.newInstance(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), bl);
        }
        if (byteBuffer.isDirect() && UnsafeDirectNioDecoder.isSupported()) {
            return new UnsafeDirectNioDecoder(byteBuffer, bl);
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(byArray);
        return CodedInputStream.newInstance(byArray, 0, byArray.length, true);
    }

    public void checkRecursionLimit() throws InvalidProtocolBufferException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
    }

    private CodedInputStream() {
    }

    public abstract int readTag() throws IOException;

    public abstract void checkLastTagWas(int var1) throws InvalidProtocolBufferException;

    public abstract int getLastTag();

    public abstract boolean skipField(int var1) throws IOException;

    @Deprecated
    public abstract boolean skipField(int var1, CodedOutputStream var2) throws IOException;

    public abstract void skipMessage() throws IOException;

    public abstract void skipMessage(CodedOutputStream var1) throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract long readUInt64() throws IOException;

    public abstract long readInt64() throws IOException;

    public abstract int readInt32() throws IOException;

    public abstract long readFixed64() throws IOException;

    public abstract int readFixed32() throws IOException;

    public abstract boolean readBool() throws IOException;

    public abstract String readString() throws IOException;

    public abstract String readStringRequireUtf8() throws IOException;

    public abstract void readGroup(int var1, MessageLite.Builder var2, ExtensionRegistryLite var3) throws IOException;

    public abstract <T extends MessageLite> T readGroup(int var1, Parser<T> var2, ExtensionRegistryLite var3) throws IOException;

    @Deprecated
    public abstract void readUnknownGroup(int var1, MessageLite.Builder var2) throws IOException;

    public abstract void readMessage(MessageLite.Builder var1, ExtensionRegistryLite var2) throws IOException;

    public abstract <T extends MessageLite> T readMessage(Parser<T> var1, ExtensionRegistryLite var2) throws IOException;

    public abstract ByteString readBytes() throws IOException;

    public abstract byte[] readByteArray() throws IOException;

    public abstract ByteBuffer readByteBuffer() throws IOException;

    public abstract int readUInt32() throws IOException;

    public abstract int readEnum() throws IOException;

    public abstract int readSFixed32() throws IOException;

    public abstract long readSFixed64() throws IOException;

    public abstract int readSInt32() throws IOException;

    public abstract long readSInt64() throws IOException;

    public abstract int readRawVarint32() throws IOException;

    public abstract long readRawVarint64() throws IOException;

    abstract long readRawVarint64SlowPath() throws IOException;

    public abstract int readRawLittleEndian32() throws IOException;

    public abstract long readRawLittleEndian64() throws IOException;

    public abstract void enableAliasing(boolean var1);

    public final int setRecursionLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + n);
        }
        int n2 = this.recursionLimit;
        this.recursionLimit = n;
        return n2;
    }

    public final int setSizeLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + n);
        }
        int n2 = this.sizeLimit;
        this.sizeLimit = n;
        return n2;
    }

    final void discardUnknownFields() {
        this.shouldDiscardUnknownFields = true;
    }

    final void unsetDiscardUnknownFields() {
        this.shouldDiscardUnknownFields = false;
    }

    final boolean shouldDiscardUnknownFields() {
        return this.shouldDiscardUnknownFields;
    }

    public abstract void resetSizeCounter();

    public abstract int pushLimit(int var1) throws InvalidProtocolBufferException;

    public abstract void popLimit(int var1);

    public abstract int getBytesUntilLimit();

    public abstract boolean isAtEnd() throws IOException;

    public abstract int getTotalBytesRead();

    public abstract byte readRawByte() throws IOException;

    public abstract byte[] readRawBytes(int var1) throws IOException;

    public abstract void skipRawBytes(int var1) throws IOException;

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    public static int readRawVarint32(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3;
        if ((n & 0x80) == 0) {
            return n;
        }
        int n4 = n & 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n4 |= (n2 & 0x7F) << n3;
            if ((n2 & 0x80) != 0) continue;
            return n4;
        }
        while (n3 < 64) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 & 0x80) == 0) {
                return n4;
            }
            n3 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    static int readRawVarint32(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(n, inputStream);
    }

    private static final class IterableDirectByteBufferDecoder
    extends CodedInputStream {
        private final Iterable<ByteBuffer> input;
        private final Iterator<ByteBuffer> iterator;
        private ByteBuffer currentByteBuffer;
        private final boolean immutable;
        private boolean enableAliasing;
        private int totalBufferSize;
        private int bufferSizeAfterCurrentLimit;
        private int currentLimit = Integer.MAX_VALUE;
        private int lastTag;
        private int totalBytesRead;
        private int startOffset;
        private long currentByteBufferPos;
        private long currentByteBufferStartPos;
        private long currentAddress;
        private long currentByteBufferLimit;

        private IterableDirectByteBufferDecoder(Iterable<ByteBuffer> iterable, int n, boolean bl) {
            this.totalBufferSize = n;
            this.input = iterable;
            this.iterator = this.input.iterator();
            this.immutable = bl;
            this.totalBytesRead = 0;
            this.startOffset = 0;
            if (n == 0) {
                this.currentByteBuffer = Internal.EMPTY_BYTE_BUFFER;
                this.currentByteBufferPos = 0L;
                this.currentByteBufferStartPos = 0L;
                this.currentByteBufferLimit = 0L;
                this.currentAddress = 0L;
            } else {
                this.tryGetNextByteBuffer();
            }
        }

        private void getNextByteBuffer() throws InvalidProtocolBufferException {
            if (!this.iterator.hasNext()) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.tryGetNextByteBuffer();
        }

        private void tryGetNextByteBuffer() {
            this.currentByteBuffer = this.iterator.next();
            this.totalBytesRead += (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
            this.currentByteBufferStartPos = this.currentByteBufferPos = (long)this.currentByteBuffer.position();
            this.currentByteBufferLimit = this.currentByteBuffer.limit();
            this.currentAddress = UnsafeUtil.addressOffset(this.currentByteBuffer);
            this.currentByteBufferPos += this.currentAddress;
            this.currentByteBufferStartPos += this.currentAddress;
            this.currentByteBufferLimit += this.currentAddress;
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n, CodedOutputStream codedOutputStream) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    long l = this.readInt64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeUInt64NoTag(l);
                    return true;
                }
                case 1: {
                    long l = this.readRawLittleEndian64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed64NoTag(l);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeUInt32NoTag(n);
                    this.skipMessage(codedOutputStream);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                    this.checkLastTagWas(n2);
                    codedOutputStream.writeUInt32NoTag(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && (long)n <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
                String string = new String(byArray, Internal.UTF_8);
                this.currentByteBufferPos += (long)n;
                return string;
            }
            if (n > 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                this.readRawBytesTo(byArray, 0, n);
                String string = new String(byArray, Internal.UTF_8);
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && (long)n <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                int n2 = (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
                String string = Utf8.decodeUtf8(this.currentByteBuffer, n2, n);
                this.currentByteBufferPos += (long)n;
                return string;
            }
            if (n >= 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                this.readRawBytesTo(byArray, 0, n);
                return Utf8.decodeUtf8(byArray, 0, n);
            }
            if (n == 0) {
                return "";
            }
            if (n <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void readGroup(int n, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n, MessageLite.Builder builder) throws IOException {
            this.readGroup(n, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && (long)n <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                if (this.immutable && this.enableAliasing) {
                    int n2 = (int)(this.currentByteBufferPos - this.currentAddress);
                    ByteString byteString = ByteString.wrap(this.slice(n2, n2 + n));
                    this.currentByteBufferPos += (long)n;
                    return byteString;
                }
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
                this.currentByteBufferPos += (long)n;
                return ByteString.wrap(byArray);
            }
            if (n > 0 && n <= this.remaining()) {
                if (this.immutable && this.enableAliasing) {
                    ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
                    int n3 = n;
                    while (n3 > 0) {
                        if (this.currentRemaining() == 0L) {
                            this.getNextByteBuffer();
                        }
                        int n4 = Math.min(n3, (int)this.currentRemaining());
                        int n5 = (int)(this.currentByteBufferPos - this.currentAddress);
                        arrayList.add(ByteString.wrap(this.slice(n5, n5 + n4)));
                        n3 -= n4;
                        this.currentByteBufferPos += (long)n4;
                    }
                    return ByteString.copyFrom(arrayList);
                }
                byte[] byArray = new byte[n];
                this.readRawBytesTo(byArray, 0, n);
                return ByteString.wrap(byArray);
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public byte[] readByteArray() throws IOException {
            return this.readRawBytes(this.readRawVarint32());
        }

        @Override
        public ByteBuffer readByteBuffer() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && (long)n <= this.currentRemaining()) {
                if (!this.immutable && this.enableAliasing) {
                    this.currentByteBufferPos += (long)n;
                    return this.slice((int)(this.currentByteBufferPos - this.currentAddress - (long)n), (int)(this.currentByteBufferPos - this.currentAddress));
                }
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
                this.currentByteBufferPos += (long)n;
                return ByteBuffer.wrap(byArray);
            }
            if (n > 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                this.readRawBytesTo(byArray, 0, n);
                return ByteBuffer.wrap(byArray);
            }
            if (n == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() throws IOException {
            return IterableDirectByteBufferDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() throws IOException {
            return IterableDirectByteBufferDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() throws IOException {
            block4: {
                int n;
                long l;
                block6: {
                    block8: {
                        block7: {
                            block5: {
                                l = this.currentByteBufferPos;
                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                if ((n = UnsafeUtil.getByte(l++)) >= 0) {
                                    ++this.currentByteBufferPos;
                                    return n;
                                }
                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                if ((n ^= UnsafeUtil.getByte(l++) << 7) >= 0) break block5;
                                n ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n ^= UnsafeUtil.getByte(l++) << 14) < 0) break block7;
                            n ^= 0x3F80;
                            break block6;
                        }
                        if ((n ^= UnsafeUtil.getByte(l++) << 21) >= 0) break block8;
                        n ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by = UnsafeUtil.getByte(l++);
                    n ^= by << 28;
                    n ^= 0xFE03F80;
                    if (by < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0) break block4;
                }
                this.currentByteBufferPos = l;
                return n;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        @Override
        public long readRawVarint64() throws IOException {
            block4: {
                long l;
                long l2;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n;
                                    block8: {
                                        block7: {
                                            block5: {
                                                l2 = this.currentByteBufferPos;
                                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                                if ((n = UnsafeUtil.getByte(l2++)) >= 0) {
                                                    ++this.currentByteBufferPos;
                                                    return n;
                                                }
                                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                                if ((n ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                                l = n ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                                            l = n ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                                        l = n ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l = (long)n ^ (long)UnsafeUtil.getByte(l2++) << 28) < 0L) break block9;
                                    l ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l ^= (long)UnsafeUtil.getByte(l2++) << 35) >= 0L) break block10;
                                l ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)UnsafeUtil.getByte(l2++) << 42) < 0L) break block11;
                            l ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)UnsafeUtil.getByte(l2++) << 49) >= 0L) break block12;
                        l ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l ^= (long)UnsafeUtil.getByte(l2++) << 56;
                    if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l2++) < 0L) break block4;
                }
                this.currentByteBufferPos = l2;
                return l;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte by = this.readRawByte();
                l |= (long)(by & 0x7F) << i;
                if ((by & 0x80) != 0) continue;
                return l;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() throws IOException {
            if (this.currentRemaining() >= 4L) {
                long l = this.currentByteBufferPos;
                this.currentByteBufferPos += 4L;
                return UnsafeUtil.getByte(l) & 0xFF | (UnsafeUtil.getByte(l + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l + 3L) & 0xFF) << 24;
            }
            return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() throws IOException {
            if (this.currentRemaining() >= 8L) {
                long l = this.currentByteBufferPos;
                this.currentByteBufferPos += 8L;
                return (long)UnsafeUtil.getByte(l) & 0xFFL | ((long)UnsafeUtil.getByte(l + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l + 7L) & 0xFFL) << 56;
            }
            return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl) {
            this.enableAliasing = bl;
        }

        @Override
        public void resetSizeCounter() {
            this.startOffset = (int)((long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            int n2;
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.totalBufferSize += this.bufferSizeAfterCurrentLimit;
            int n = this.totalBufferSize - this.startOffset;
            if (n > this.currentLimit) {
                this.bufferSizeAfterCurrentLimit = n - this.currentLimit;
                this.totalBufferSize -= this.bufferSizeAfterCurrentLimit;
            } else {
                this.bufferSizeAfterCurrentLimit = 0;
            }
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public boolean isAtEnd() throws IOException {
            return (long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos == (long)this.totalBufferSize;
        }

        @Override
        public int getTotalBytesRead() {
            return (int)((long)(this.totalBytesRead - this.startOffset) + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        @Override
        public byte readRawByte() throws IOException {
            if (this.currentRemaining() == 0L) {
                this.getNextByteBuffer();
            }
            return UnsafeUtil.getByte(this.currentByteBufferPos++);
        }

        @Override
        public byte[] readRawBytes(int n) throws IOException {
            if (n >= 0 && (long)n <= this.currentRemaining()) {
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
                this.currentByteBufferPos += (long)n;
                return byArray;
            }
            if (n >= 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                this.readRawBytesTo(byArray, 0, n);
                return byArray;
            }
            if (n <= 0) {
                if (n == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void readRawBytesTo(byte[] byArray, int n, int n2) throws IOException {
            if (n2 >= 0 && n2 <= this.remaining()) {
                int n3 = n2;
                while (n3 > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int n4 = Math.min(n3, (int)this.currentRemaining());
                    UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, (long)(n2 - n3 + n), (long)n4);
                    n3 -= n4;
                    this.currentByteBufferPos += (long)n4;
                }
                return;
            }
            if (n2 <= 0) {
                if (n2 == 0) {
                    return;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void skipRawBytes(int n) throws IOException {
            if (n >= 0 && (long)n <= (long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos) {
                int n2 = n;
                while (n2 > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int n3 = Math.min(n2, (int)this.currentRemaining());
                    n2 -= n3;
                    this.currentByteBufferPos += (long)n3;
                }
                return;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void skipRawVarint() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private int remaining() {
            return (int)((long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos);
        }

        private long currentRemaining() {
            return this.currentByteBufferLimit - this.currentByteBufferPos;
        }

        private ByteBuffer slice(int n, int n2) throws IOException {
            int n3 = this.currentByteBuffer.position();
            int n4 = this.currentByteBuffer.limit();
            ByteBuffer byteBuffer = this.currentByteBuffer;
            try {
                ((Buffer)byteBuffer).position(n);
                ((Buffer)byteBuffer).limit(n2);
                ByteBuffer byteBuffer2 = this.currentByteBuffer.slice();
                return byteBuffer2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            finally {
                ((Buffer)byteBuffer).position(n3);
                ((Buffer)byteBuffer).limit(n4);
            }
        }
    }

    private static final class StreamDecoder
    extends CodedInputStream {
        private final InputStream input;
        private final byte[] buffer;
        private int bufferSize;
        private int bufferSizeAfterLimit;
        private int pos;
        private int lastTag;
        private int totalBytesRetired;
        private int currentLimit = Integer.MAX_VALUE;
        private RefillCallback refillCallback = null;

        private StreamDecoder(InputStream inputStream, int n) {
            Internal.checkNotNull(inputStream, "input");
            this.input = inputStream;
            this.buffer = new byte[n];
            this.bufferSize = 0;
            this.pos = 0;
            this.totalBytesRetired = 0;
        }

        private static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
            try {
                return inputStream.read(byArray, n, n2);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException;
            }
        }

        private static long skip(InputStream inputStream, long l) throws IOException {
            try {
                return inputStream.skip(l);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException;
            }
        }

        private static int available(InputStream inputStream) throws IOException {
            try {
                return inputStream.available();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException;
            }
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n, CodedOutputStream codedOutputStream) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    long l = this.readInt64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeUInt64NoTag(l);
                    return true;
                }
                case 1: {
                    long l = this.readRawLittleEndian64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed64NoTag(l);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeUInt32NoTag(n);
                    this.skipMessage(codedOutputStream);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                    this.checkLastTagWas(n2);
                    codedOutputStream.writeUInt32NoTag(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.bufferSize - this.pos) {
                String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
                this.pos += n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n <= this.bufferSize) {
                this.refillBuffer(n);
                String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
                this.pos += n;
                return string;
            }
            return new String(this.readRawBytesSlowPath(n, false), Internal.UTF_8);
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            int n;
            byte[] byArray;
            int n2;
            int n3 = this.readRawVarint32();
            if (n3 <= this.bufferSize - (n2 = this.pos) && n3 > 0) {
                byArray = this.buffer;
                this.pos = n2 + n3;
                n = n2;
            } else {
                if (n3 == 0) {
                    return "";
                }
                if (n3 <= this.bufferSize) {
                    this.refillBuffer(n3);
                    byArray = this.buffer;
                    n = 0;
                    this.pos = n + n3;
                } else {
                    byArray = this.readRawBytesSlowPath(n3, false);
                    n = 0;
                }
            }
            return Utf8.decodeUtf8(byArray, n, n3);
        }

        @Override
        public void readGroup(int n, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n, MessageLite.Builder builder) throws IOException {
            this.readGroup(n, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n <= this.bufferSize - this.pos && n > 0) {
                ByteString byteString = ByteString.copyFrom(this.buffer, this.pos, n);
                this.pos += n;
                return byteString;
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            return this.readBytesSlowPath(n);
        }

        @Override
        public byte[] readByteArray() throws IOException {
            int n = this.readRawVarint32();
            if (n <= this.bufferSize - this.pos && n > 0) {
                byte[] byArray = Arrays.copyOfRange(this.buffer, this.pos, this.pos + n);
                this.pos += n;
                return byArray;
            }
            return this.readRawBytesSlowPath(n, false);
        }

        @Override
        public ByteBuffer readByteBuffer() throws IOException {
            int n = this.readRawVarint32();
            if (n <= this.bufferSize - this.pos && n > 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n));
                this.pos += n;
                return byteBuffer;
            }
            if (n == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            return ByteBuffer.wrap(this.readRawBytesSlowPath(n, true));
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() throws IOException {
            return StreamDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() throws IOException {
            return StreamDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() throws IOException {
            block4: {
                int n;
                int n2;
                block6: {
                    byte[] byArray;
                    block8: {
                        block7: {
                            block5: {
                                n2 = this.pos;
                                if (this.bufferSize == n2) break block4;
                                byArray = this.buffer;
                                if ((n = byArray[n2++]) >= 0) {
                                    this.pos = n2;
                                    return n;
                                }
                                if (this.bufferSize - n2 < 9) break block4;
                                if ((n ^= byArray[n2++] << 7) >= 0) break block5;
                                n ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n ^= byArray[n2++] << 14) < 0) break block7;
                            n ^= 0x3F80;
                            break block6;
                        }
                        if ((n ^= byArray[n2++] << 21) >= 0) break block8;
                        n ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by = byArray[n2++];
                    n ^= by << 28;
                    n ^= 0xFE03F80;
                    if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
                }
                this.pos = n2;
                return n;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() throws IOException {
            if (this.bufferSize - this.pos >= 10) {
                this.skipRawVarintFastPath();
            } else {
                this.skipRawVarintSlowPath();
            }
        }

        private void skipRawVarintFastPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.buffer[this.pos++] < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public long readRawVarint64() throws IOException {
            block4: {
                long l;
                int n;
                block6: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n2;
                                    block8: {
                                        block7: {
                                            block5: {
                                                n = this.pos;
                                                if (this.bufferSize == n) break block4;
                                                byArray = this.buffer;
                                                if ((n2 = byArray[n++]) >= 0) {
                                                    this.pos = n;
                                                    return n2;
                                                }
                                                if (this.bufferSize - n < 9) break block4;
                                                if ((n2 ^= byArray[n++] << 7) >= 0) break block5;
                                                l = n2 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n2 ^= byArray[n++] << 14) < 0) break block7;
                                            l = n2 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n2 ^= byArray[n++] << 21) >= 0) break block8;
                                        l = n2 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l = (long)n2 ^ (long)byArray[n++] << 28) < 0L) break block9;
                                    l ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                                l ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                            l ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                        l ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l ^= (long)byArray[n++] << 56;
                    if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
                }
                this.pos = n;
                return l;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte by = this.readRawByte();
                l |= (long)(by & 0x7F) << i;
                if ((by & 0x80) != 0) continue;
                return l;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() throws IOException {
            int n = this.pos;
            if (this.bufferSize - n < 4) {
                this.refillBuffer(4);
                n = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n + 4;
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() throws IOException {
            int n = this.pos;
            if (this.bufferSize - n < 8) {
                this.refillBuffer(8);
                n = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n + 8;
            return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl) {
        }

        @Override
        public void resetSizeCounter() {
            this.totalBytesRetired = -this.pos;
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n2 = this.currentLimit;
            if ((n += this.totalBytesRetired + this.pos) > n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.bufferSize += this.bufferSizeAfterLimit;
            int n = this.totalBytesRetired + this.bufferSize;
            if (n > this.currentLimit) {
                this.bufferSizeAfterLimit = n - this.currentLimit;
                this.bufferSize -= this.bufferSizeAfterLimit;
            } else {
                this.bufferSizeAfterLimit = 0;
            }
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            int n = this.totalBytesRetired + this.pos;
            return this.currentLimit - n;
        }

        @Override
        public boolean isAtEnd() throws IOException {
            return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
        }

        @Override
        public int getTotalBytesRead() {
            return this.totalBytesRetired + this.pos;
        }

        private void refillBuffer(int n) throws IOException {
            if (!this.tryRefillBuffer(n)) {
                if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    throw InvalidProtocolBufferException.sizeLimitExceeded();
                }
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private boolean tryRefillBuffer(int n) throws IOException {
            int n2;
            int n3;
            if (this.pos + n <= this.bufferSize) {
                throw new IllegalStateException("refillBuffer() called when " + n + " bytes were already available in buffer");
            }
            if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                return false;
            }
            if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
                return false;
            }
            if (this.refillCallback != null) {
                this.refillCallback.onRefill();
            }
            if ((n3 = this.pos) > 0) {
                if (this.bufferSize > n3) {
                    System.arraycopy(this.buffer, n3, this.buffer, 0, this.bufferSize - n3);
                }
                this.totalBytesRetired += n3;
                this.bufferSize -= n3;
                this.pos = 0;
            }
            if ((n2 = StreamDecoder.read(this.input, this.buffer, this.bufferSize, Math.min(this.buffer.length - this.bufferSize, this.sizeLimit - this.totalBytesRetired - this.bufferSize))) == 0 || n2 < -1 || n2 > this.buffer.length) {
                throw new IllegalStateException(this.input.getClass() + "#read(byte[]) returned invalid result: " + n2 + "\nThe InputStream implementation is buggy.");
            }
            if (n2 > 0) {
                this.bufferSize += n2;
                this.recomputeBufferSizeAfterLimit();
                return this.bufferSize >= n ? true : this.tryRefillBuffer(n);
            }
            return false;
        }

        @Override
        public byte readRawByte() throws IOException {
            if (this.pos == this.bufferSize) {
                this.refillBuffer(1);
            }
            return this.buffer[this.pos++];
        }

        @Override
        public byte[] readRawBytes(int n) throws IOException {
            int n2 = this.pos;
            if (n <= this.bufferSize - n2 && n > 0) {
                this.pos = n2 + n;
                return Arrays.copyOfRange(this.buffer, n2, n2 + n);
            }
            return this.readRawBytesSlowPath(n, false);
        }

        private byte[] readRawBytesSlowPath(int n, boolean bl) throws IOException {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(n);
            if (byArray != null) {
                return bl ? (byte[])byArray.clone() : byArray;
            }
            int n2 = this.pos;
            int n3 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int n4 = n - n3;
            List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n4);
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, n2, byArray2, 0, n3);
            int n5 = n3;
            for (byte[] byArray3 : list) {
                System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
                n5 += byArray3.length;
            }
            return byArray2;
        }

        private byte[] readRawBytesSlowPathOneChunk(int n) throws IOException {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n2 = this.totalBytesRetired + this.pos + n;
            if (n2 - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (n2 > this.currentLimit) {
                this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int n3 = this.bufferSize - this.pos;
            int n4 = n - n3;
            if (n4 < 4096 || n4 <= StreamDecoder.available(this.input)) {
                int n5;
                byte[] byArray = new byte[n];
                System.arraycopy(this.buffer, this.pos, byArray, 0, n3);
                this.totalBytesRetired += this.bufferSize;
                this.pos = 0;
                this.bufferSize = 0;
                for (int i = n3; i < byArray.length; i += n5) {
                    n5 = StreamDecoder.read(this.input, byArray, i, n - i);
                    if (n5 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n5;
                }
                return byArray;
            }
            return null;
        }

        private List<byte[]> readRawBytesSlowPathRemainingChunks(int n) throws IOException {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            while (n > 0) {
                int n2;
                byte[] byArray = new byte[Math.min(n, 4096)];
                for (int i = 0; i < byArray.length; i += n2) {
                    n2 = this.input.read(byArray, i, byArray.length - i);
                    if (n2 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n2;
                }
                n -= byArray.length;
                arrayList.add(byArray);
            }
            return arrayList;
        }

        private ByteString readBytesSlowPath(int n) throws IOException {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(n);
            if (byArray != null) {
                return ByteString.copyFrom(byArray);
            }
            int n2 = this.pos;
            int n3 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int n4 = n - n3;
            List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n4);
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, n2, byArray2, 0, n3);
            int n5 = n3;
            for (byte[] byArray3 : list) {
                System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
                n5 += byArray3.length;
            }
            return ByteString.wrap(byArray2);
        }

        @Override
        public void skipRawBytes(int n) throws IOException {
            if (n <= this.bufferSize - this.pos && n >= 0) {
                this.pos += n;
            } else {
                this.skipRawBytesSlowPath(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skipRawBytesSlowPath(int n) throws IOException {
            int n2;
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
                this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int n3 = 0;
            if (this.refillCallback == null) {
                this.totalBytesRetired += this.pos;
                this.bufferSize = 0;
                this.pos = 0;
                try {
                    long l;
                    for (n3 = this.bufferSize - this.pos; n3 < n; n3 += (int)l) {
                        n2 = n - n3;
                        l = StreamDecoder.skip(this.input, n2);
                        if (l < 0L || l > (long)n2) {
                            throw new IllegalStateException(this.input.getClass() + "#skip returned invalid result: " + l + "\nThe InputStream implementation is buggy.");
                        }
                        if (l != 0L) continue;
                        break;
                    }
                }
                finally {
                    this.totalBytesRetired += n3;
                    this.recomputeBufferSizeAfterLimit();
                }
            }
            if (n3 < n) {
                n2 = this.bufferSize - this.pos;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
                while (n - n2 > this.bufferSize) {
                    n2 += this.bufferSize;
                    this.pos = this.bufferSize;
                    this.refillBuffer(1);
                }
                this.pos = n - n2;
            }
        }

        private static interface RefillCallback {
            public void onRefill();
        }

        private class SkippedDataSink
        implements RefillCallback {
            private int lastPos;
            private ByteArrayOutputStream byteArrayStream;

            private SkippedDataSink() {
                this.lastPos = StreamDecoder.this.pos;
            }

            @Override
            public void onRefill() {
                if (this.byteArrayStream == null) {
                    this.byteArrayStream = new ByteArrayOutputStream();
                }
                this.byteArrayStream.write(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos - this.lastPos);
                this.lastPos = 0;
            }

            ByteBuffer getSkippedData() {
                if (this.byteArrayStream == null) {
                    return ByteBuffer.wrap(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos - this.lastPos);
                }
                this.byteArrayStream.write(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos);
                return ByteBuffer.wrap(this.byteArrayStream.toByteArray());
            }
        }
    }

    private static final class UnsafeDirectNioDecoder
    extends CodedInputStream {
        private final ByteBuffer buffer;
        private final boolean immutable;
        private final long address;
        private long limit;
        private long pos;
        private long startPos;
        private int bufferSizeAfterLimit;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        private UnsafeDirectNioDecoder(ByteBuffer byteBuffer, boolean bl) {
            this.buffer = byteBuffer;
            this.address = UnsafeUtil.addressOffset(byteBuffer);
            this.limit = this.address + (long)byteBuffer.limit();
            this.startPos = this.pos = this.address + (long)byteBuffer.position();
            this.immutable = bl;
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n, CodedOutputStream codedOutputStream) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    long l = this.readInt64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeUInt64NoTag(l);
                    return true;
                }
                case 1: {
                    long l = this.readRawLittleEndian64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed64NoTag(l);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeUInt32NoTag(n);
                    this.skipMessage(codedOutputStream);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                    this.checkLastTagWas(n2);
                    codedOutputStream.writeUInt32NoTag(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n);
                String string = new String(byArray, Internal.UTF_8);
                this.pos += (long)n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                int n2 = this.bufferPos(this.pos);
                String string = Utf8.decodeUtf8(this.buffer, n2, n);
                this.pos += (long)n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void readGroup(int n, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n, MessageLite.Builder builder) throws IOException {
            this.readGroup(n, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                if (this.immutable && this.enableAliasing) {
                    ByteBuffer byteBuffer = this.slice(this.pos, this.pos + (long)n);
                    this.pos += (long)n;
                    return ByteString.wrap(byteBuffer);
                }
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n);
                this.pos += (long)n;
                return ByteString.wrap(byArray);
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public byte[] readByteArray() throws IOException {
            return this.readRawBytes(this.readRawVarint32());
        }

        @Override
        public ByteBuffer readByteBuffer() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.remaining()) {
                if (!this.immutable && this.enableAliasing) {
                    ByteBuffer byteBuffer = this.slice(this.pos, this.pos + (long)n);
                    this.pos += (long)n;
                    return byteBuffer;
                }
                byte[] byArray = new byte[n];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n);
                this.pos += (long)n;
                return ByteBuffer.wrap(byArray);
            }
            if (n == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() throws IOException {
            block4: {
                int n;
                long l;
                block6: {
                    block8: {
                        block7: {
                            block5: {
                                l = this.pos;
                                if (this.limit == l) break block4;
                                if ((n = UnsafeUtil.getByte(l++)) >= 0) {
                                    this.pos = l;
                                    return n;
                                }
                                if (this.limit - l < 9L) break block4;
                                if ((n ^= UnsafeUtil.getByte(l++) << 7) >= 0) break block5;
                                n ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n ^= UnsafeUtil.getByte(l++) << 14) < 0) break block7;
                            n ^= 0x3F80;
                            break block6;
                        }
                        if ((n ^= UnsafeUtil.getByte(l++) << 21) >= 0) break block8;
                        n ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by = UnsafeUtil.getByte(l++);
                    n ^= by << 28;
                    n ^= 0xFE03F80;
                    if (by < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0) break block4;
                }
                this.pos = l;
                return n;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() throws IOException {
            if (this.remaining() >= 10) {
                this.skipRawVarintFastPath();
            } else {
                this.skipRawVarintSlowPath();
            }
        }

        private void skipRawVarintFastPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (UnsafeUtil.getByte(this.pos++) < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public long readRawVarint64() throws IOException {
            block4: {
                long l;
                long l2;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n;
                                    block8: {
                                        block7: {
                                            block5: {
                                                l2 = this.pos;
                                                if (this.limit == l2) break block4;
                                                if ((n = UnsafeUtil.getByte(l2++)) >= 0) {
                                                    this.pos = l2;
                                                    return n;
                                                }
                                                if (this.limit - l2 < 9L) break block4;
                                                if ((n ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                                l = n ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                                            l = n ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                                        l = n ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l = (long)n ^ (long)UnsafeUtil.getByte(l2++) << 28) < 0L) break block9;
                                    l ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l ^= (long)UnsafeUtil.getByte(l2++) << 35) >= 0L) break block10;
                                l ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)UnsafeUtil.getByte(l2++) << 42) < 0L) break block11;
                            l ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)UnsafeUtil.getByte(l2++) << 49) >= 0L) break block12;
                        l ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l ^= (long)UnsafeUtil.getByte(l2++) << 56;
                    if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l2++) < 0L) break block4;
                }
                this.pos = l2;
                return l;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte by = this.readRawByte();
                l |= (long)(by & 0x7F) << i;
                if ((by & 0x80) != 0) continue;
                return l;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() throws IOException {
            long l = this.pos;
            if (this.limit - l < 4L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l + 4L;
            return UnsafeUtil.getByte(l) & 0xFF | (UnsafeUtil.getByte(l + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l + 3L) & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() throws IOException {
            long l = this.pos;
            if (this.limit - l < 8L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l + 8L;
            return (long)UnsafeUtil.getByte(l) & 0xFFL | ((long)UnsafeUtil.getByte(l + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l + 7L) & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl) {
            this.enableAliasing = bl;
        }

        @Override
        public void resetSizeCounter() {
            this.startPos = this.pos;
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            int n2;
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public boolean isAtEnd() throws IOException {
            return this.pos == this.limit;
        }

        @Override
        public int getTotalBytesRead() {
            return (int)(this.pos - this.startPos);
        }

        @Override
        public byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return UnsafeUtil.getByte(this.pos++);
        }

        @Override
        public byte[] readRawBytes(int n) throws IOException {
            if (n >= 0 && n <= this.remaining()) {
                byte[] byArray = new byte[n];
                this.slice(this.pos, this.pos + (long)n).get(byArray);
                this.pos += (long)n;
                return byArray;
            }
            if (n <= 0) {
                if (n == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void skipRawBytes(int n) throws IOException {
            if (n >= 0 && n <= this.remaining()) {
                this.pos += (long)n;
                return;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += (long)this.bufferSizeAfterLimit;
            int n = (int)(this.limit - this.startPos);
            if (n > this.currentLimit) {
                this.bufferSizeAfterLimit = n - this.currentLimit;
                this.limit -= (long)this.bufferSizeAfterLimit;
            } else {
                this.bufferSizeAfterLimit = 0;
            }
        }

        private int remaining() {
            return (int)(this.limit - this.pos);
        }

        private int bufferPos(long l) {
            return (int)(l - this.address);
        }

        private ByteBuffer slice(long l, long l2) throws IOException {
            int n = this.buffer.position();
            int n2 = this.buffer.limit();
            ByteBuffer byteBuffer = this.buffer;
            try {
                ((Buffer)byteBuffer).position(this.bufferPos(l));
                ((Buffer)byteBuffer).limit(this.bufferPos(l2));
                ByteBuffer byteBuffer2 = this.buffer.slice();
                return byteBuffer2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InvalidProtocolBufferException invalidProtocolBufferException = InvalidProtocolBufferException.truncatedMessage();
                invalidProtocolBufferException.initCause(illegalArgumentException);
                throw invalidProtocolBufferException;
            }
            finally {
                ((Buffer)byteBuffer).position(n);
                ((Buffer)byteBuffer).limit(n2);
            }
        }
    }

    private static final class ArrayDecoder
    extends CodedInputStream {
        private final byte[] buffer;
        private final boolean immutable;
        private int limit;
        private int bufferSizeAfterLimit;
        private int pos;
        private int startPos;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        private ArrayDecoder(byte[] byArray, int n, int n2, boolean bl) {
            this.buffer = byArray;
            this.limit = n + n2;
            this.startPos = this.pos = n;
            this.immutable = bl;
        }

        @Override
        public int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
            if (this.lastTag != n) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public int getLastTag() {
            return this.lastTag;
        }

        @Override
        public boolean skipField(int n) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public boolean skipField(int n, CodedOutputStream codedOutputStream) throws IOException {
            switch (WireFormat.getTagWireType(n)) {
                case 0: {
                    long l = this.readInt64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeUInt64NoTag(l);
                    return true;
                }
                case 1: {
                    long l = this.readRawLittleEndian64();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed64NoTag(l);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    codedOutputStream.writeUInt32NoTag(n);
                    this.skipMessage(codedOutputStream);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                    this.checkLastTagWas(n2);
                    codedOutputStream.writeUInt32NoTag(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    codedOutputStream.writeUInt32NoTag(n);
                    codedOutputStream.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public void skipMessage() throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n)) {
            }
        }

        @Override
        public void skipMessage(CodedOutputStream codedOutputStream) throws IOException {
            int n;
            while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
            }
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public String readString() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
                this.pos += n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public String readStringRequireUtf8() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                String string = Utf8.decodeUtf8(this.buffer, this.pos, n);
                this.pos += n;
                return string;
            }
            if (n == 0) {
                return "";
            }
            if (n <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void readGroup(int n, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
        }

        @Override
        public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            this.checkRecursionLimit();
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(WireFormat.makeTag(n, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public void readUnknownGroup(int n, MessageLite.Builder builder) throws IOException {
            this.readGroup(n, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
        }

        @Override
        public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = this.readRawVarint32();
            this.checkRecursionLimit();
            int n2 = this.pushLimit(n);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            if (this.getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.popLimit(n2);
            return (T)messageLite;
        }

        @Override
        public ByteString readBytes() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                ByteString byteString = this.immutable && this.enableAliasing ? ByteString.wrap(this.buffer, this.pos, n) : ByteString.copyFrom(this.buffer, this.pos, n);
                this.pos += n;
                return byteString;
            }
            if (n == 0) {
                return ByteString.EMPTY;
            }
            return ByteString.wrap(this.readRawBytes(n));
        }

        @Override
        public byte[] readByteArray() throws IOException {
            int n = this.readRawVarint32();
            return this.readRawBytes(n);
        }

        @Override
        public ByteBuffer readByteBuffer() throws IOException {
            int n = this.readRawVarint32();
            if (n > 0 && n <= this.limit - this.pos) {
                ByteBuffer byteBuffer = !this.immutable && this.enableAliasing ? ByteBuffer.wrap(this.buffer, this.pos, n).slice() : ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n));
                this.pos += n;
                return byteBuffer;
            }
            if (n == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public int readSInt32() throws IOException {
            return ArrayDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public long readSInt64() throws IOException {
            return ArrayDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public int readRawVarint32() throws IOException {
            block4: {
                int n;
                int n2;
                block6: {
                    byte[] byArray;
                    block8: {
                        block7: {
                            block5: {
                                n2 = this.pos;
                                if (this.limit == n2) break block4;
                                byArray = this.buffer;
                                if ((n = byArray[n2++]) >= 0) {
                                    this.pos = n2;
                                    return n;
                                }
                                if (this.limit - n2 < 9) break block4;
                                if ((n ^= byArray[n2++] << 7) >= 0) break block5;
                                n ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n ^= byArray[n2++] << 14) < 0) break block7;
                            n ^= 0x3F80;
                            break block6;
                        }
                        if ((n ^= byArray[n2++] << 21) >= 0) break block8;
                        n ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by = byArray[n2++];
                    n ^= by << 28;
                    n ^= 0xFE03F80;
                    if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
                }
                this.pos = n2;
                return n;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                this.skipRawVarintFastPath();
            } else {
                this.skipRawVarintSlowPath();
            }
        }

        private void skipRawVarintFastPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.buffer[this.pos++] < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public long readRawVarint64() throws IOException {
            block4: {
                long l;
                int n;
                block6: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n2;
                                    block8: {
                                        block7: {
                                            block5: {
                                                n = this.pos;
                                                if (this.limit == n) break block4;
                                                byArray = this.buffer;
                                                if ((n2 = byArray[n++]) >= 0) {
                                                    this.pos = n;
                                                    return n2;
                                                }
                                                if (this.limit - n < 9) break block4;
                                                if ((n2 ^= byArray[n++] << 7) >= 0) break block5;
                                                l = n2 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n2 ^= byArray[n++] << 14) < 0) break block7;
                                            l = n2 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n2 ^= byArray[n++] << 21) >= 0) break block8;
                                        l = n2 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l = (long)n2 ^ (long)byArray[n++] << 28) < 0L) break block9;
                                    l ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                                l ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                            l ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                        l ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l ^= (long)byArray[n++] << 56;
                    if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
                }
                this.pos = n;
                return l;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        long readRawVarint64SlowPath() throws IOException {
            long l = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte by = this.readRawByte();
                l |= (long)(by & 0x7F) << i;
                if ((by & 0x80) != 0) continue;
                return l;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public int readRawLittleEndian32() throws IOException {
            int n = this.pos;
            if (this.limit - n < 4) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n + 4;
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        @Override
        public long readRawLittleEndian64() throws IOException {
            int n = this.pos;
            if (this.limit - n < 8) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n + 8;
            return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        @Override
        public void enableAliasing(boolean bl) {
            this.enableAliasing = bl;
        }

        @Override
        public void resetSizeCounter() {
            this.startPos = this.pos;
        }

        @Override
        public int pushLimit(int n) throws InvalidProtocolBufferException {
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((n += this.getTotalBytesRead()) < 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            int n2 = this.currentLimit;
            if (n > n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += this.bufferSizeAfterLimit;
            int n = this.limit - this.startPos;
            if (n > this.currentLimit) {
                this.bufferSizeAfterLimit = n - this.currentLimit;
                this.limit -= this.bufferSizeAfterLimit;
            } else {
                this.bufferSizeAfterLimit = 0;
            }
        }

        @Override
        public void popLimit(int n) {
            this.currentLimit = n;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public boolean isAtEnd() throws IOException {
            return this.pos == this.limit;
        }

        @Override
        public int getTotalBytesRead() {
            return this.pos - this.startPos;
        }

        @Override
        public byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        @Override
        public byte[] readRawBytes(int n) throws IOException {
            if (n > 0 && n <= this.limit - this.pos) {
                int n2 = this.pos;
                this.pos += n;
                return Arrays.copyOfRange(this.buffer, n2, this.pos);
            }
            if (n <= 0) {
                if (n == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public void skipRawBytes(int n) throws IOException {
            if (n >= 0 && n <= this.limit - this.pos) {
                this.pos += n;
                return;
            }
            if (n < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }
}

