/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.AbstractProtobufList;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class BooleanArrayList
extends AbstractProtobufList<Boolean>
implements Internal.BooleanList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final BooleanArrayList EMPTY_LIST = new BooleanArrayList(new boolean[0], 0, false);
    private boolean[] array;
    private int size;

    public static BooleanArrayList emptyList() {
        return EMPTY_LIST;
    }

    BooleanArrayList() {
        this(new boolean[10], 0, true);
    }

    private BooleanArrayList(boolean[] blArray, int n, boolean bl) {
        super(bl);
        this.array = blArray;
        this.size = n;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.ensureIsMutable();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n2, this.array, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanArrayList)) {
            return super.equals(object);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)object;
        if (this.size != booleanArrayList.size) {
            return false;
        }
        boolean[] blArray = booleanArrayList.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + Internal.hashBoolean(this.array[i]);
        }
        return n;
    }

    @Override
    public Internal.BooleanList mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new BooleanArrayList(Arrays.copyOf(this.array, n), this.size, true);
    }

    @Override
    public Boolean get(int n) {
        return this.getBoolean(n);
    }

    @Override
    public boolean getBoolean(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.array[i] != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Boolean set(int n, Boolean bl) {
        return this.setBoolean(n, bl);
    }

    @Override
    public boolean setBoolean(int n, boolean bl) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        boolean bl2 = this.array[n];
        this.array[n] = bl;
        return bl2;
    }

    @Override
    public boolean add(Boolean bl) {
        this.addBoolean(bl);
        return true;
    }

    @Override
    public void add(int n, Boolean bl) {
        this.addBoolean(n, bl);
    }

    @Override
    public void addBoolean(boolean bl) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.array, 0, blArray, 0, this.size);
            this.array = blArray;
        }
        this.array[this.size++] = bl;
    }

    private void addBoolean(int n, boolean bl) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.array, 0, blArray, 0, n);
            System.arraycopy(this.array, n, blArray, n + 1, this.size - n);
            this.array = blArray;
        }
        this.array[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof BooleanArrayList)) {
            return super.addAll(collection);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)collection;
        if (booleanArrayList.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < booleanArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n2 = this.size + booleanArrayList.size;
        if (n2 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n2);
        }
        System.arraycopy(booleanArrayList.array, 0, this.array, this.size, booleanArrayList.size);
        this.size = n2;
        ++this.modCount;
        return true;
    }

    @Override
    public Boolean remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        boolean bl = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        }
        --this.size;
        ++this.modCount;
        return bl;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        return "Index:" + n + ", Size:" + this.size;
    }
}

