/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.protocol;

import com.mathworks.apache.http.HttpConnection;
import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpInetConnection;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpRequestInterceptor;
import com.mathworks.apache.http.HttpVersion;
import com.mathworks.apache.http.ProtocolException;
import com.mathworks.apache.http.ProtocolVersion;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.protocol.HttpContext;
import com.mathworks.apache.http.protocol.HttpCoreContext;
import com.mathworks.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

