/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.nio.protocol;

import com.mathworks.apache.http.ConnectionReuseStrategy;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.nio.NHttpConnection;
import com.mathworks.apache.http.nio.protocol.EventListener;
import com.mathworks.apache.http.nio.util.ByteBufferAllocator;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.protocol.HttpProcessor;
import com.mathworks.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Immutable
public abstract class NHttpHandlerBase {
    protected static final String CONN_STATE = "http.nio.conn-state";
    protected final HttpProcessor httpProcessor;
    protected final ConnectionReuseStrategy connStrategy;
    protected final ByteBufferAllocator allocator;
    protected final HttpParams params;
    protected EventListener eventListener;

    public NHttpHandlerBase(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(httpProcessor, "HTTP processor");
        Args.notNull(connStrategy, "Connection reuse strategy");
        Args.notNull(allocator, "ByteBuffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.allocator = allocator;
        this.params = params;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    protected void closeConnection(NHttpConnection conn, Throwable cause) {
        try {
            conn.close();
        }
        catch (IOException ex) {
            try {
                conn.shutdown();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    protected void shutdownConnection(NHttpConnection conn, Throwable cause) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleTimeout(NHttpConnection conn) {
        try {
            if (conn.getStatus() == 0) {
                conn.close();
                if (conn.getStatus() == 1) {
                    conn.setSocketTimeout(250);
                }
                if (this.eventListener != null) {
                    this.eventListener.connectionTimeout(conn);
                }
            } else {
                conn.shutdown();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

