/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.pool;

import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.HttpResponseFactory;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.config.ConnectionConfig;
import com.mathworks.apache.http.impl.DefaultHttpResponseFactory;
import com.mathworks.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import com.mathworks.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import com.mathworks.apache.http.nio.NHttpClientConnection;
import com.mathworks.apache.http.nio.NHttpConnectionFactory;
import com.mathworks.apache.http.nio.NHttpMessageParserFactory;
import com.mathworks.apache.http.nio.NHttpMessageWriterFactory;
import com.mathworks.apache.http.nio.pool.NIOConnFactory;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.mathworks.apache.http.nio.util.ByteBufferAllocator;
import com.mathworks.apache.http.nio.util.HeapByteBufferAllocator;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Immutable
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslcontext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

