/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.HTTPErrorInfo;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.io.IOException;
import java.io.InputStream;

public class OnErrorCallback
implements FutureCallback<HttpResponse> {
    private MWRequestImpl request;
    private ApacheHttpClient apacheClient;

    public OnErrorCallback(MWRequestImpl mWRequestImpl, ApacheHttpClient apacheHttpClient) {
        this.request = mWRequestImpl;
        this.apacheClient = apacheHttpClient;
    }

    @Override
    public void failed(Exception exception) {
        this.request.updateStateAndNotify(new FailedMWRequestState(exception));
        this.apacheClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(HttpResponse httpResponse) {
        try {
            HTTPErrorInfo.HTTP_Error_Info hTTP_Error_Info = this.parseHttpErrorInfo(httpResponse);
            MWHttpException mWHttpException = new MWHttpException(hTTP_Error_Info.getHttpCode(), hTTP_Error_Info.getHttpMessage());
            this.request.updateStateAndNotify(new FailedMWRequestState(mWHttpException));
        }
        catch (IOException iOException) {
            this.request.updateStateAndNotify(new FailedMWRequestState(iOException));
        }
        finally {
            this.apacheClient.requestsCreated.remove(this.request.getClientRequestInfo().getRequestUrl());
            this.apacheClient.getClientUsageLock().usageExit();
        }
    }

    @Override
    public void cancelled() {
        this.apacheClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPErrorInfo.HTTP_Error_Info parseHttpErrorInfo(HttpResponse httpResponse) throws IOException {
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            codedInputStream.setSizeLimit(this.apacheClient.getResponseSizeLimit());
            HTTPErrorInfo.HTTP_Error_Info hTTP_Error_Info = HTTPErrorInfo.HTTP_Error_Info.parseFrom(codedInputStream);
            return hTTP_Error_Info;
        }
        finally {
            inputStream.close();
        }
    }
}

