/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;

public class MWFuture<T>
implements Future<T> {
    static final int RUNNING = 0;
    static final int COMPLETED = 1;
    static final int CANCELLED = 2;
    static final int INTERRUPTED = 3;
    public final Object lock = new Object();
    private MWRequestImpl<T> request;
    private int state;
    private T response = null;
    private CancellationException cancelException;
    private ExecutionException execException;
    private InterruptedException interruptException;
    public Boolean finished = false;
    public final boolean markedForCancellation = false;
    private final Logger LOG;

    public MWFuture(MWRequestImpl<T> mWRequestImpl) {
        this.request = mWRequestImpl;
        this.LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
    }

    public void setState(int n) {
        this.state = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws ExecutionException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.LOG.trace("MWFuture get: wait loop entry, for request: {}", (Object)this.request.getRequestURL());
            while (!this.finished.booleanValue()) {
                this.lock.wait();
            }
            this.LOG.trace("MWFuture get: wait loop exit, for request: {}", (Object)this.request.getRequestURL());
        }
        return this.getValue();
    }

    @Override
    public boolean isCancelled() {
        return this.state == 2;
    }

    private T getValue() throws CancellationException, ExecutionException, InterruptedException {
        switch (this.state) {
            case 2: {
                throw this.cancelException;
            }
            case 3: {
                throw this.interruptException;
            }
            case 1: {
                if (this.execException != null) {
                    throw this.execException;
                }
                return this.response;
            }
        }
        throw new IllegalStateException("Get the right error message");
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.request.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = System.currentTimeMillis();
        long l3 = timeUnit.toMillis(l);
        long l4 = l2 + timeUnit.toMillis(l);
        Object object = this.lock;
        synchronized (object) {
            this.LOG.trace("MWFuture get: wait loop entry");
            while (!this.finished.booleanValue() && System.currentTimeMillis() < l4) {
                this.lock.wait(l3);
                this.LOG.debug("MWFuture get: waited {}ms, finished: {}", (Object)l3, (Object)this.finished);
            }
            this.LOG.debug("MWFuture get: wait loop exit, finished: {}", (Object)this.finished);
        }
        if (this.finished.booleanValue()) {
            return this.getValue();
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isDone() {
        return this.state == 1 || this.state == 2;
    }

    void set(T t) {
        this.response = t;
        this.state = 1;
        this.LOG.trace("MWFuture state: COMPLETED, after receiving result for request: {}", (Object)this.request.getRequestURL());
    }

    void setCancelException(CancellationException cancellationException) {
        this.cancelException = cancellationException;
        this.state = 2;
        this.LOG.trace("MWFuture state: CANCELLED, for request:{}", (Object)this.request.getRequestURL());
    }

    void setInterruptedException(InterruptedException interruptedException) {
        this.interruptException = interruptedException;
        this.state = 3;
        this.LOG.trace("MWFuture state: INTERRUPTED for request:{}", (Object)this.request.getRequestURL());
    }

    void setExecException(ExecutionException executionException) {
        this.execException = executionException;
        this.state = 1;
        this.LOG.trace("MWFuture state: COMPLETED with exception, for request:{}", (Object)this.request.getRequestURL());
    }
}

