/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.internal.JavaDataExtractor;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import java.util.List;

public class ResponseBuilder<T> {
    final int nargout;
    final Class<T> targetType;
    final boolean hasNargout;
    final MWAttributesContainer attributesContainer;
    final String functionName;

    public ResponseBuilder(int n, Class<T> clazz, boolean bl, MWAttributesContainer mWAttributesContainer, String string) {
        this.nargout = n;
        this.targetType = clazz;
        this.hasNargout = bl;
        this.attributesContainer = mWAttributesContainer;
        this.functionName = string;
    }

    public Object createMATLABResponse(MATLABResult.MATLAB_Result mATLAB_Result) throws MATLABException {
        this.checkMLResultForErrors(mATLAB_Result);
        List<MATLABArray.MATLAB_Array> list = mATLAB_Result.getLhsList();
        if (list.size() == 0) {
            return null;
        }
        JavaDataExtractor javaDataExtractor = new JavaDataExtractor(this.attributesContainer);
        Object[] objectArray = new Object[list.size()];
        Class clazz = this.hasNargout ? Object.class : this.targetType;
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = javaDataExtractor.toJavaType(list.get(i), clazz);
        }
        return this.hasNargout ? objectArray : objectArray[0];
    }

    private void checkMLResultForErrors(MATLABResult.MATLAB_Result mATLAB_Result) throws MATLABException {
        if (!mATLAB_Result.hasError()) {
            if (mATLAB_Result.getLhsCount() != this.nargout) {
                throw new IllegalArgumentException("Incorrect number of outputs returned from MATLAB.\nMATLAB returned " + mATLAB_Result.getLhsCount() + " number of outputs,\nMethod ," + this.functionName + ", expected " + this.nargout + " number of outputs.");
            }
        } else {
            MATLABError.MATLAB_Error mATLAB_Error = mATLAB_Result.getError();
            throw new MATLABException(mATLAB_Error.getMessage(), mATLAB_Error.getIdentifier(), MWInvocationHandlerUtils.convertToMATLABStackFrameList(mATLAB_Error.getStackList()));
        }
    }
}

