/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.google.protobuf.ExtensionRegistry;
import com.mathworks.mps.client.MATLABStackFrame;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.MWSSLServerAuthorizer;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABArrayFactory;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;

public class MWInvocationHandlerUtils {
    static ExtensionRegistry extRegistry = ExtensionRegistry.newInstance();

    public static MATLABParams.MATLAB_Params createMATLABParams(int n, Object[] objectArray, MWAttributesContainer mWAttributesContainer) {
        if (n < 0) {
            throw new IllegalArgumentException("For a method with Object[] as output type and first input of type int,\nthe first input value is always treated as number of outputs from the \ncorresponding MATLAB function and not as one of the inputs for it.\nNumber of outputs for a MATLAB function must be greater than 0.");
        }
        MATLABParams.MATLAB_Params.Builder builder = MATLABParams.MATLAB_Params.newBuilder();
        builder.setNargout(n);
        MWInvocationHandlerUtils.updateMATLABParamsWithFuncInputs(builder, objectArray, mWAttributesContainer);
        return builder.build();
    }

    private static void updateMATLABParamsWithFuncInputs(MATLABParams.MATLAB_Params.Builder builder, Object[] objectArray, MWAttributesContainer mWAttributesContainer) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                builder.addRhs(MATLABArrayFactory.newInstance(object, mWAttributesContainer));
            }
        }
    }

    public static List<MATLABStackFrame> convertToMATLABStackFrameList(List<MATLABError.MATLAB_Error.Stack_Frame> list) {
        ArrayList<MATLABStackFrame> arrayList = new ArrayList<MATLABStackFrame>();
        for (MATLABError.MATLAB_Error.Stack_Frame stack_Frame : list) {
            arrayList.add(new MATLABStackFrame(stack_Frame.getFile(), stack_Frame.getName(), stack_Frame.getLine()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static void throwIfServerIsNotAuthorized(Certificate[] certificateArray, MWSSLConfig mWSSLConfig) throws SSLException {
        MWSSLServerAuthorizer mWSSLServerAuthorizer = mWSSLConfig.getServerAuthorizer();
        if (mWSSLServerAuthorizer != null) {
            if (certificateArray.length > 0) {
                if (!mWSSLServerAuthorizer.authorize(certificateArray[0])) {
                    throw new SSLException("MPS client failed to authorize the server.");
                }
            } else if (mWSSLServerAuthorizer.isCertificateRequired()) {
                throw new SSLException("MPS client failed to authorize the server because it did not receive a certificate from server");
            }
        }
    }

    static {
        MATLABArray.registerAllExtensions(extRegistry);
    }
}

