/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.methods.CloseableHttpResponse;
import com.mathworks.apache.http.client.methods.HttpDelete;
import com.mathworks.apache.http.client.methods.HttpGet;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.client.methods.HttpUriRequest;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.client.utils.URIBuilder;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.config.Registry;
import com.mathworks.apache.http.config.RegistryBuilder;
import com.mathworks.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.mathworks.apache.http.entity.ByteArrayEntity;
import com.mathworks.apache.http.impl.client.CloseableHttpClient;
import com.mathworks.apache.http.impl.client.HttpClients;
import com.mathworks.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.mathworks.apache.http.impl.nio.client.HttpAsyncClients;
import com.mathworks.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import com.mathworks.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.mathworks.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import com.mathworks.apache.http.impl.nio.reactor.IOReactorConfig;
import com.mathworks.apache.http.nio.client.HttpAsyncClient;
import com.mathworks.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.mathworks.apache.http.nio.conn.NHttpConnectionFactory;
import com.mathworks.apache.http.nio.conn.NoopIOSessionStrategy;
import com.mathworks.apache.http.nio.conn.SchemeIOSessionStrategy;
import com.mathworks.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import com.mathworks.apache.http.nio.reactor.ConnectingIOReactor;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.internal.AbstractHttpClient;
import com.mathworks.mps.client.internal.HTTPErrorInfo;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABRequestCreated;
import com.mathworks.mps.client.internal.MATLABRequestInfo;
import com.mathworks.mps.client.internal.MATLABRequestNotification;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.internal.MWSSLContext;
import com.mathworks.mps.client.internal.async.CancelledMWRequestState;
import com.mathworks.mps.client.internal.async.HttpResponseCallback;
import com.mathworks.mps.client.internal.async.InQueueMWRequestState;
import com.mathworks.mps.client.internal.async.InstanceInfo;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.OnErrorCallback;
import com.mathworks.mps.client.internal.async.ProcessingMWRequestState;
import com.mathworks.mps.client.internal.async.RequestNotificationsCallback;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;

public class ApacheHttpClient
extends AbstractHttpClient {
    private final CloseableHttpAsyncClient httpClientAsync;
    private final CloseableHttpClient httpClient;
    private final int responseSizeLimit;
    private final MWHttpClient mwClient;
    private MWClientUsageLock clientUsageLock;
    private Thread backupGETThread;
    private final Logger LOG;
    private final Object lock = new Object();
    public ConcurrentHashMap<UUID, InstanceInfo> instances = new ConcurrentHashMap();
    public ConcurrentHashMap<String, ConcurrentHashMap<String, MWRequestImpl>> requestsCreated = new ConcurrentHashMap();
    public ConcurrentHashMap<String, MATLABRequestInfo.MATLAB_Request_Info> pendingNotifications = new ConcurrentHashMap();
    public ConcurrentHashMap<UUID, MWRequestImpl> pendingRequests = new ConcurrentHashMap();

    public ApacheHttpClient(MWHttpClientConfig mWHttpClientConfig, final MWSSLConfig mWSSLConfig, MWHttpClient mWHttpClient) {
        super(mWHttpClientConfig.getResponseSizeLimit());
        this.LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
        this.responseSizeLimit = mWHttpClientConfig.getResponseSizeLimit();
        this.mwClient = mWHttpClient;
        try {
            SSLContext sSLContext = mWSSLConfig.getSSLContext() == null ? MWSSLContext.getDefault() : mWSSLConfig.getSSLContext();
            HostnameVerifier hostnameVerifier = mWSSLConfig.getHostnameVerifier();
            SSLIOSessionStrategy sSLIOSessionStrategy = new SSLIOSessionStrategy(sSLContext, hostnameVerifier){

                @Override
                protected void verifySession(HttpHost httpHost, IOSession iOSession, SSLSession sSLSession) throws SSLException {
                    ApacheHttpClient.this.verifySSLSession(iOSession, sSLSession, mWSSLConfig);
                }
            };
            Registry<SchemeIOSessionStrategy> registry = RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)sSLIOSessionStrategy)).build();
            IOReactorConfig iOReactorConfig = IOReactorConfig.custom().setConnectTimeout((int)mWHttpClientConfig.getTimeOutMs()).setSoTimeout((int)mWHttpClientConfig.getTimeOutMs()).setTcpNoDelay(false).build();
            DefaultConnectingIOReactor defaultConnectingIOReactor = new DefaultConnectingIOReactor(iOReactorConfig);
            ManagedNHttpClientConnectionFactory managedNHttpClientConnectionFactory = new ManagedNHttpClientConnectionFactory();
            PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)defaultConnectingIOReactor, (NHttpConnectionFactory<ManagedNHttpClientConnection>)managedNHttpClientConnectionFactory, registry);
            poolingNHttpClientConnectionManager.setDefaultMaxPerRoute(mWHttpClientConfig.getMaxConnectionsPerAddress());
            this.httpClientAsync = HttpAsyncClients.custom().setUserAgent(ApacheHttpClient.class.getName()).setConnectionManager(poolingNHttpClientConnectionManager).setSSLContext(sSLContext).setSSLHostnameVerifier(hostnameVerifier).setSSLStrategy(sSLIOSessionStrategy).build();
            this.httpClientAsync.start();
            this.httpClient = HttpClients.custom().setUserAgent(ApacheHttpClient.class.getName()).setSslcontext(sSLContext).setSSLHostnameVerifier(hostnameVerifier).build();
        }
        catch (Exception exception) {
            throw new RuntimeException("Trouble initializing MWHttpClient", exception);
        }
    }

    private void verifySSLSession(IOSession iOSession, SSLSession sSLSession, MWSSLConfig mWSSLConfig) throws SSLException {
        block3: {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)iOSession.getRemoteAddress();
            try {
                Certificate[] certificateArray = sSLSession.getPeerCertificates();
                if (certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) {
                    throw new SSLPeerUnverifiedException("No X509 certificate provided by the peer");
                }
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                DefaultHostnameVerifier defaultHostnameVerifier = new DefaultHostnameVerifier();
                defaultHostnameVerifier.verify(inetSocketAddress.getHostName(), x509Certificate);
            }
            catch (SSLException sSLException) {
                HostnameVerifier hostnameVerifier = mWSSLConfig.getHostnameVerifier();
                if (hostnameVerifier != null && hostnameVerifier.verify(inetSocketAddress.getHostName(), sSLSession)) break block3;
                throw sSLException;
            }
        }
        MWInvocationHandlerUtils.throwIfServerIsNotAuthorized(sSLSession.getPeerCertificates(), mWSSLConfig);
    }

    public HttpAsyncClient getHttpClientAsync() {
        return this.httpClientAsync;
    }

    public int getResponseSizeLimit() {
        return this.responseSizeLimit;
    }

    public MWHttpClient getMWClient() {
        return this.mwClient;
    }

    public MWClientUsageLock getClientUsageLock() {
        return this.clientUsageLock;
    }

    public void setClientUsageLock(MWClientUsageLock mWClientUsageLock) {
        this.clientUsageLock = mWClientUsageLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void executePost(HttpPost httpPost, MATLABParams.MATLAB_Params mATLAB_Params, HttpClientContext httpClientContext, HttpResponseCallback<T> httpResponseCallback) {
        httpPost.addHeader("Content-Type", "application/x-google-protobuf");
        if (mATLAB_Params != null) {
            httpPost.setEntity(new ByteArrayEntity(mATLAB_Params.toByteArray()));
        }
        try {
            this.LOG.info("MATLAB execution request: {}", (Object)httpPost);
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)httpPost, httpClientContext);
            try {
                httpResponseCallback.completed(closeableHttpResponse);
            }
            finally {
                closeableHttpResponse.close();
            }
        }
        catch (Exception exception) {
            httpResponseCallback.failed(exception);
        }
    }

    public <T> void executePostCancel(HttpPost httpPost, MATLABParams.MATLAB_Params mATLAB_Params, HttpClientContext httpClientContext, HttpResponseCallback<T> httpResponseCallback) {
        this.LOG.trace("Execute POST cancel - {}", (Object)httpPost);
        this.LOG.trace("HTTP context - {}", (Object)httpClientContext);
        httpPost.addHeader("Content-Type", "application/x-google-protobuf");
        if (mATLAB_Params != null) {
            httpPost.setEntity(new ByteArrayEntity(mATLAB_Params.toByteArray()));
        }
        this.httpClientAsync.execute(httpPost, httpClientContext, httpResponseCallback);
    }

    public void executeGet(HttpGet httpGet, HttpClientContext httpClientContext, FutureCallback<HttpResponse> futureCallback) {
        this.clientUsageLock.usageEnter(null);
        this.httpClientAsync.execute(httpGet, httpClientContext, futureCallback);
    }

    public Future<HttpResponse> executeGetSync(URI uRI, HttpClientContext httpClientContext) throws URISyntaxException {
        HttpGet httpGet = new HttpGet(uRI.toString());
        return this.httpClientAsync.execute(httpGet, httpClientContext, null);
    }

    public void executeDelete(String string, HttpClientContext httpClientContext) {
        HttpDelete httpDelete = new HttpDelete(string);
        this.LOG.trace("Execute DELETE - {}", (Object)httpDelete);
        this.LOG.trace("HTTP context - {}", (Object)httpClientContext);
        httpDelete.addHeader("Content-Type", "application/x-google-protobuf");
        this.httpClientAsync.execute(httpDelete, httpClientContext, null);
    }

    public void executeGetForNotifications(InstanceInfo instanceInfo) throws URISyntaxException {
        URI uRI = this.buildGetUpdatesSinceUri(instanceInfo);
        HttpGet httpGet = new HttpGet(uRI.toString());
        httpGet.setHeader("X-MPS-Start-Time", instanceInfo.getSessionId());
        instanceInfo.httpGet = httpGet;
        try {
            this.LOG.debug("Server state update request: {}", (Object)httpGet);
            this.executeGet(httpGet, instanceInfo.getHttpContext(), instanceInfo.getNotificationCallback());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        instanceInfo.notificationRecent.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateRequest(String string, MATLABRequestInfo.MATLAB_Request_Info mATLAB_Request_Info, String string2) {
        try {
            MATLABRequestInfo.MATLAB_Request_Info.State state = mATLAB_Request_Info.getState();
            MWRequestImpl mWRequestImpl = this.requestsCreated.get(string2).get(string);
            if (mWRequestImpl == null) {
                this.pendingNotifications.put(string, mATLAB_Request_Info);
                mWRequestImpl = this.requestsCreated.get(string2).get(string);
                if (mWRequestImpl == null) {
                    return;
                }
                mATLAB_Request_Info = this.pendingNotifications.remove(string);
                if (mATLAB_Request_Info == null) {
                    return;
                }
            }
            String string3 = mWRequestImpl.getClientRequestInfo().getInstance().getServerUri();
            HttpClientContext httpClientContext = mWRequestImpl.getClientRequestInfo().getInstance().getHttpContext();
            MWRequestInfo mWRequestInfo = mWRequestImpl.getClientRequestInfo();
            switch (state) {
                case READING_STATE: {
                    mWRequestImpl.markCreated();
                    break;
                }
                case IN_QUEUE_STATE: {
                    mWRequestImpl.updateStateAndNotify(new InQueueMWRequestState(mATLAB_Request_Info.getLastModified(), new URL(string3 + string), mWRequestInfo));
                    break;
                }
                case PROCESSING_STATE: {
                    mWRequestImpl.updateStateAndNotify(new ProcessingMWRequestState(mATLAB_Request_Info.getLastModified(), new URL(string3 + string), mWRequestInfo));
                    break;
                }
                case READY_STATE: {
                    URI uRI = this.buildGetResultUri(string3, string);
                    HttpGet httpGet = new HttpGet(uRI.toString());
                    Object object = mWRequestImpl.lock;
                    synchronized (object) {
                        if (mWRequestImpl.httpGetResponse != null) {
                            break;
                        }
                        try {
                            this.LOG.debug("MATLAB result request: {}", (Object)httpGet);
                            this.executeGet(httpGet, httpClientContext, new HttpResponseCallback(string3, mWRequestImpl, this, httpClientContext));
                        }
                        catch (IllegalStateException illegalStateException) {
                            break;
                        }
                        mWRequestImpl.markReadingResponse(httpGet);
                        break;
                    }
                }
                case ERROR_STATE: {
                    URI uRI = this.buildGetResultUri(string3, string);
                    HttpGet httpGet = new HttpGet(uRI.toString());
                    Object object = mWRequestImpl.lock;
                    synchronized (object) {
                        if (mWRequestImpl.httpGetError != null) {
                            break;
                        }
                        try {
                            this.executeGet(httpGet, httpClientContext, new OnErrorCallback(mWRequestImpl, this));
                        }
                        catch (IllegalStateException illegalStateException) {
                            break;
                        }
                        mWRequestImpl.markReadingError(httpGet);
                        break;
                    }
                }
                case CANCELLED_STATE: {
                    mWRequestImpl.updateStateAndNotify(new CancelledMWRequestState());
                    this.requestsCreated.remove(mWRequestImpl.getClientRequestInfo().getRequestUrl());
                    break;
                }
                case DELETED_STATE: {
                    break;
                }
                case UNKNOWN_STATE: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerRequest(MWRequestImpl<T> mWRequestImpl, UUID uUID, String string, String string2, HttpClientContext httpClientContext) throws URISyntaxException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.instances.containsKey(uUID)) {
                this.instances.put(uUID, new InstanceInfo(uUID, string, -1, string2, httpClientContext));
            }
            if (!this.requestsCreated.containsKey(string2)) {
                this.requestsCreated.put(string2, new ConcurrentHashMap());
            }
        }
        object = this.instances.get(uUID);
        ((InstanceInfo)object).getWaitNotifier().cancel();
        MWRequestInfo<T> mWRequestInfo = mWRequestImpl.getClientRequestInfo();
        mWRequestInfo.setInstance((InstanceInfo)object);
        this.requestsCreated.get(string2).put(mWRequestInfo.getRequestUrl(), mWRequestImpl);
        this.LOG.debug("Request URI created by server: {}", (Object)mWRequestImpl.getRequestURL());
        this.LOG.trace("Information of server processing the request: {}", object);
        Object object2 = ((InstanceInfo)object).lock;
        synchronized (object2) {
            if (!((InstanceInfo)object).isNotificationRunning()) {
                RequestNotificationsCallback requestNotificationsCallback = new RequestNotificationsCallback((InstanceInfo)object, this);
                ((InstanceInfo)object).setNotificationRunningTrue(requestNotificationsCallback);
                this.executeGetForNotifications((InstanceInfo)object);
            }
        }
    }

    public URI buildGetResultUri(String string, String string2) throws URISyntaxException {
        URIBuilder uRIBuilder = new URIBuilder(string + string2 + "/result");
        uRIBuilder.addParameter("format", "protobuf");
        return uRIBuilder.build();
    }

    public URI buildGetUpdatesSinceUri(InstanceInfo instanceInfo) throws URISyntaxException {
        URIBuilder uRIBuilder = new URIBuilder(instanceInfo.getLocation());
        uRIBuilder.setPath(uRIBuilder.getPath() + "requests");
        uRIBuilder.addParameter("since", Long.toString(instanceInfo.getCurrentSeq() + 1L));
        uRIBuilder.addParameter("format", "protobuf");
        uRIBuilder.addParameter("clients", this.mwClient.getClientUUID().toString());
        return uRIBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATLABResult.MATLAB_Result parseMATLABResult(HttpResponse httpResponse) throws IOException {
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            codedInputStream.setSizeLimit(this.responseSizeLimit);
            MATLABResult.MATLAB_Result mATLAB_Result = MATLABResult.MATLAB_Result.parseFrom(codedInputStream, (ExtensionRegistryLite)MWInvocationHandlerUtils.extRegistry);
            return mATLAB_Result;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATLABRequestCreated.MATLAB_Request_Created parseMATLABRequest(HttpResponse httpResponse) throws IOException {
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            codedInputStream.setSizeLimit(this.responseSizeLimit);
            MATLABRequestCreated.MATLAB_Request_Created mATLAB_Request_Created = MATLABRequestCreated.MATLAB_Request_Created.parseFrom(codedInputStream);
            return mATLAB_Request_Created;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATLABRequestNotification.MATLAB_Request_Notification parseRequestNotification(HttpResponse httpResponse) throws IOException {
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            codedInputStream.setSizeLimit(this.responseSizeLimit);
            MATLABRequestNotification.MATLAB_Request_Notification mATLAB_Request_Notification = MATLABRequestNotification.MATLAB_Request_Notification.parseFrom(codedInputStream);
            return mATLAB_Request_Notification;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPErrorInfo.HTTP_Error_Info parseHttpErrorInfo(HttpResponse httpResponse) throws IOException {
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            codedInputStream.setSizeLimit(this.responseSizeLimit);
            HTTPErrorInfo.HTTP_Error_Info hTTP_Error_Info = HTTPErrorInfo.HTTP_Error_Info.parseFrom(codedInputStream);
            return hTTP_Error_Info;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            try {
                new ShutdownApache().start();
            }
            catch (Exception exception) {
                throw new RuntimeException("Trouble closing MWHttpClient", exception);
            }
        }
    }

    private class ShutdownApache
    extends Thread {
        private ShutdownApache() {
        }

        @Override
        public void run() {
            try {
                ApacheHttpClient.this.httpClientAsync.close();
                ApacheHttpClient.this.httpClient.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

