/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.config.RequestConfig;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.client.utils.URIBuilder;
import com.mathworks.apache.http.entity.ByteArrayEntity;
import com.mathworks.apache.http.impl.client.BasicCookieStore;
import com.mathworks.apache.http.nio.client.HttpAsyncClient;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.ResponseProducer;
import com.mathworks.mps.client.internal.async.HttpResponseCallback;
import com.mathworks.mps.client.internal.async.InstanceInfo;
import com.mathworks.mps.client.internal.async.InterruptedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.SendingMWRequestState;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class ApacheFevalHandler
implements MWFevalHandler {
    private final ApacheHttpClient httpClient;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public ApacheFevalHandler(ApacheHttpClient apacheHttpClient) {
        this.httpClient = apacheHttpClient;
    }

    @Override
    public <T> MWRequest<T> processRequest(URL uRL, MATLABParams.MATLAB_Params mATLAB_Params, ResponseProducer<T> responseProducer, MWRequestListener<T> mWRequestListener) {
        MWHttpClient mWHttpClient = this.httpClient.getMWClient();
        HttpPost httpPost = new HttpPost(uRL.toString());
        String string = this.parseServerURI(uRL);
        MWRequestInfo<T> mWRequestInfo = new MWRequestInfo<T>(responseProducer, mWHttpClient.getClientUUID(), uRL);
        MWRequestImpl<T> mWRequestImpl = new MWRequestImpl<T>(mWHttpClient, mWRequestListener, mWRequestInfo, this);
        mWRequestImpl.httpPost = httpPost;
        this.httpClient.pendingRequests.put(mWRequestImpl.getTempId(), mWRequestImpl);
        mWRequestImpl.updateStateAndNotify(new SendingMWRequestState<T>(mATLAB_Params.toByteArray(), uRL, mWRequestInfo));
        String string2 = !mWHttpClient.getConfig().isCookieEnabled() ? "ignoreCookies" : "default";
        this.LOG.trace("Setting cookie spec : {}", (Object)string2);
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setCookieStore(new BasicCookieStore());
        httpClientContext.setRequestConfig(RequestConfig.custom().setCookieSpec(string2).build());
        this.httpClient.executePost(httpPost, mATLAB_Params, httpClientContext, new HttpResponseCallback<T>(string, mWRequestImpl, this.httpClient, httpClientContext));
        return mWRequestImpl;
    }

    private String parseServerURI(URL uRL) {
        URIBuilder uRIBuilder = new URIBuilder();
        uRIBuilder.setScheme(uRL.getProtocol());
        uRIBuilder.setHost(uRL.getHost());
        uRIBuilder.setPort(uRL.getPort());
        return uRIBuilder.toString();
    }

    @Override
    public MATLABResult.MATLAB_Result processRequest(URL uRL, MATLABParams.MATLAB_Params mATLAB_Params) throws Throwable {
        HttpPost httpPost = new HttpPost(uRL.toString());
        httpPost.addHeader("Content-Type", "application/x-google-protobuf");
        httpPost.setEntity(new ByteArrayEntity(mATLAB_Params.toByteArray()));
        HttpAsyncClient httpAsyncClient = this.httpClient.getHttpClientAsync();
        this.LOG.info("MATLAB execution request: {}", (Object)uRL);
        Future<HttpResponse> future = httpAsyncClient.execute(httpPost, null);
        try {
            HttpResponse httpResponse = future.get();
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n == 200) {
                return this.httpClient.parseMATLABResult(httpResponse);
            }
            throw new MWHttpException(n, httpResponse.getStatusLine().getReasonPhrase());
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    @Override
    public void close() {
        this.LOG.trace("Closing Apache HTTP client");
        this.httpClient.close();
    }

    @Override
    public boolean isClosed() {
        return this.httpClient.isClosed();
    }

    public ApacheHttpClient getApacheHttpClient() {
        return this.httpClient;
    }

    @Override
    public void abort() {
        this.LOG.trace("Aborting all pending requests. Number of requests not acknowledged by the server: {}", (Object)this.httpClient.pendingRequests.size());
        for (MWRequestImpl object : this.httpClient.pendingRequests.values()) {
            this.LOG.trace("Aborting request: {}", (Object)object.getClientRequestInfo().getSrcRequestURL());
            object.abort();
        }
        this.httpClient.pendingRequests.clear();
        this.LOG.trace("Aborting all update notification loops. Number of server instances: {}", (Object)this.httpClient.instances.size());
        for (InstanceInfo instanceInfo : this.httpClient.instances.values()) {
            instanceInfo.httpGet.abort();
            String string = instanceInfo.getSessionId();
            if (this.httpClient.requestsCreated.containsKey(string)) {
                for (MWRequestImpl mWRequestImpl : this.httpClient.requestsCreated.get(string).values()) {
                    mWRequestImpl.updateStateAndNotify(new InterruptedMWRequestState());
                }
                this.httpClient.requestsCreated.get(string).clear();
            }
            instanceInfo.getWaitNotifier().cancel();
        }
        this.httpClient.close();
    }
}

