/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import java.util.logging.Logger;

public final class RuntimeVersion {
    public static final RuntimeDomain DOMAIN = RuntimeDomain.PUBLIC;
    public static final int MAJOR = 4;
    public static final int MINOR = 26;
    public static final int PATCH = 1;
    public static final String SUFFIX = "";
    private static final String VERSION_STRING = RuntimeVersion.versionString(4, 26, 1, "");
    private static final Logger logger = Logger.getLogger(RuntimeVersion.class.getName());

    public static void validateProtobufGencodeVersion(RuntimeDomain runtimeDomain, int n, int n2, int n3, String string, String string2) {
        if (RuntimeVersion.checkDisabled()) {
            return;
        }
        RuntimeVersion.validateProtobufGencodeVersionImpl(runtimeDomain, n, n2, n3, string, string2);
    }

    private static void validateProtobufGencodeVersionImpl(RuntimeDomain runtimeDomain, int n, int n2, int n3, String string, String string2) {
        if (RuntimeVersion.checkDisabled()) {
            return;
        }
        String string3 = RuntimeVersion.versionString(n, n2, n3, string);
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new ProtobufRuntimeVersionException("Invalid gencode version: " + string3);
        }
        if (runtimeDomain != DOMAIN) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime domains when loading %s: gencode %s, runtime %s. Cross-domain usage of Protobuf is not supported.", new Object[]{string2, runtimeDomain, DOMAIN}));
        }
        if (n != 4) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime major versions when loading %s: gencode %s, runtime %s. Same major version is required.", string2, string3, VERSION_STRING));
        }
        if (26 < n2 || 26 == n2 && 1 < n3) {
            throw new ProtobufRuntimeVersionException(String.format("Detected incompatible Protobuf Gencode/Runtime versions when loading %s: gencode %s, runtime %s. Runtime version cannot be older than the linked gencode version.", string2, string3, VERSION_STRING));
        }
        if (!string.equals(SUFFIX)) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime version suffixes when loading %s: gencode %s, runtime %s. Version suffixes must be the same.", string2, string3, VERSION_STRING));
        }
    }

    private static String versionString(int n, int n2, int n3, String string) {
        return String.format("%d.%d.%d%s", n, n2, n3, string);
    }

    private static boolean checkDisabled() {
        String string = System.getenv("TEMORARILY_DISABLE_PROTOBUF_VERSION_CHECK");
        return string != null && string.equals("true");
    }

    private RuntimeVersion() {
    }

    public static final class ProtobufRuntimeVersionException
    extends RuntimeException {
        public ProtobufRuntimeVersionException(String string) {
            super(string);
        }
    }

    public static enum RuntimeDomain {
        GOOGLE_INTERNAL,
        PUBLIC;

    }
}

