/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.MessageInfo;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.ProtoSyntax;

@CheckReturnValue
final class RawMessageInfo
implements MessageInfo {
    private static final int IS_PROTO2_BIT = 1;
    private static final int IS_EDITION_BIT = 4;
    private final MessageLite defaultInstance;
    private final String info;
    private final Object[] objects;
    private final int flags;

    RawMessageInfo(MessageLite messageLite, String string, Object[] objectArray) {
        this.defaultInstance = messageLite;
        this.info = string;
        this.objects = objectArray;
        int n = 0;
        char c = string.charAt(n++);
        if (c < '\ud800') {
            this.flags = c;
        } else {
            int n2 = c & 0x1FFF;
            int n3 = 13;
            while ((c = string.charAt(n++)) >= '\ud800') {
                n2 |= (c & 0x1FFF) << n3;
                n3 += 13;
            }
            this.flags = n2 | c << n3;
        }
    }

    String getStringInfo() {
        return this.info;
    }

    Object[] getObjects() {
        return this.objects;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public ProtoSyntax getSyntax() {
        if ((this.flags & 1) != 0) {
            return ProtoSyntax.PROTO2;
        }
        if ((this.flags & 4) == 4) {
            return ProtoSyntax.EDITIONS;
        }
        return ProtoSyntax.PROTO3;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return (this.flags & 2) == 2;
    }
}

