/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.GeneratedMessageLite;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.TextFormatEscaper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";
    private static final char[] INDENT_BUFFER = new char[80];

    private MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(string);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder stringBuilder, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        TreeMap<String, Method> treeMap = new TreeMap<String, Method>();
        for (Method method : messageLite.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getName().length() < 3) continue;
            if (method.getName().startsWith("set")) {
                hashSet.add(method.getName());
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("has")) {
                hashMap.put(method.getName(), method);
                continue;
            }
            if (!method.getName().startsWith("get")) continue;
            treeMap.put(method.getName(), method);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            Method method;
            String string = ((String)entry.getKey()).substring(3);
            if (string.endsWith(LIST_SUFFIX) && !string.endsWith(BUILDER_LIST_SUFFIX) && !string.equals(LIST_SUFFIX) && (method = (Method)entry.getValue()) != null && method.getReturnType().equals(List.class)) {
                MessageLiteToString.printField(stringBuilder, n, string.substring(0, string.length() - LIST_SUFFIX.length()), GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]));
                continue;
            }
            if (string.endsWith(MAP_SUFFIX) && !string.equals(MAP_SUFFIX) && (method = (Method)entry.getValue()) != null && method.getReturnType().equals(Map.class) && !method.isAnnotationPresent(Deprecated.class) && Modifier.isPublic(method.getModifiers())) {
                MessageLiteToString.printField(stringBuilder, n, string.substring(0, string.length() - MAP_SUFFIX.length()), GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]));
                continue;
            }
            if (!hashSet.contains("set" + string) || string.endsWith(BYTES_SUFFIX) && treeMap.containsKey("get" + string.substring(0, string.length() - BYTES_SUFFIX.length()))) continue;
            method = (Method)entry.getValue();
            Method method2 = (Method)hashMap.get("has" + string);
            if (method == null) continue;
            Object object = GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]);
            boolean bl = method2 == null ? !MessageLiteToString.isDefaultValue(object) : (Boolean)GeneratedMessageLite.invokeOrDie(method2, messageLite, new Object[0]);
            boolean bl2 = bl;
            if (!bl2) continue;
            MessageLiteToString.printField(stringBuilder, n, string, object);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iterator = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                MessageLiteToString.printField(stringBuilder, n, "[" + ((GeneratedMessageLite.ExtensionDescriptor)entry.getKey()).getNumber() + "]", entry.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(stringBuilder, n);
        }
    }

    private static boolean isDefaultValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof Integer) {
            return (Integer)object == 0;
        }
        if (object instanceof Float) {
            return Float.floatToRawIntBits(((Float)object).floatValue()) == 0;
        }
        if (object instanceof Double) {
            return Double.doubleToRawLongBits((Double)object) == 0L;
        }
        if (object instanceof String) {
            return object.equals("");
        }
        if (object instanceof ByteString) {
            return object.equals(ByteString.EMPTY);
        }
        if (object instanceof MessageLite) {
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (object instanceof Enum) {
            return ((Enum)object).ordinal() == 0;
        }
        return false;
    }

    static void printField(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object instanceof List) {
            List list = (List)object;
            for (Object e : list) {
                MessageLiteToString.printField(stringBuilder, n, string, e);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                MessageLiteToString.printField(stringBuilder, n, string, entry);
            }
            return;
        }
        stringBuilder.append('\n');
        MessageLiteToString.indent(n, stringBuilder);
        stringBuilder.append(MessageLiteToString.pascalCaseToSnakeCase(string));
        if (object instanceof String) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
        } else if (object instanceof ByteString) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
        } else if (object instanceof GeneratedMessageLite) {
            stringBuilder.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, stringBuilder, n + 2);
            stringBuilder.append("\n");
            MessageLiteToString.indent(n, stringBuilder);
            stringBuilder.append("}");
        } else if (object instanceof Map.Entry) {
            stringBuilder.append(" {");
            Map.Entry entry = (Map.Entry)object;
            MessageLiteToString.printField(stringBuilder, n + 2, "key", entry.getKey());
            MessageLiteToString.printField(stringBuilder, n + 2, "value", entry.getValue());
            stringBuilder.append("\n");
            MessageLiteToString.indent(n, stringBuilder);
            stringBuilder.append("}");
        } else {
            stringBuilder.append(": ").append(object);
        }
    }

    private static void indent(int n, StringBuilder stringBuilder) {
        while (n > 0) {
            int n2 = n;
            if (n2 > INDENT_BUFFER.length) {
                n2 = INDENT_BUFFER.length;
            }
            stringBuilder.append(INDENT_BUFFER, 0, n2);
            n -= n2;
        }
    }

    private static String pascalCaseToSnakeCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toLowerCase(string.charAt(0)));
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }

    static {
        Arrays.fill(INDENT_BUFFER, ' ');
    }
}

