/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.AllocatedBuffer;
import com.mathworks.google.protobuf.BooleanArrayList;
import com.mathworks.google.protobuf.BufferAllocator;
import com.mathworks.google.protobuf.ByteOutput;
import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CanIgnoreReturnValue;
import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.CodedOutputStream;
import com.mathworks.google.protobuf.DoubleArrayList;
import com.mathworks.google.protobuf.FloatArrayList;
import com.mathworks.google.protobuf.IntArrayList;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.Java8Compatibility;
import com.mathworks.google.protobuf.LazyStringList;
import com.mathworks.google.protobuf.LongArrayList;
import com.mathworks.google.protobuf.MapEntryLite;
import com.mathworks.google.protobuf.Protobuf;
import com.mathworks.google.protobuf.Schema;
import com.mathworks.google.protobuf.UnsafeUtil;
import com.mathworks.google.protobuf.Utf8;
import com.mathworks.google.protobuf.WireFormat;
import com.mathworks.google.protobuf.Writer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;

@CheckReturnValue
abstract class BinaryWriter
extends ByteOutput
implements Writer {
    public static final int DEFAULT_CHUNK_SIZE = 4096;
    private final BufferAllocator alloc;
    private final int chunkSize;
    final ArrayDeque<AllocatedBuffer> buffers = new ArrayDeque(4);
    int totalDoneBytes;
    private static final int MAP_KEY_NUMBER = 1;
    private static final int MAP_VALUE_NUMBER = 2;

    public static BinaryWriter newHeapInstance(BufferAllocator bufferAllocator) {
        return BinaryWriter.newHeapInstance(bufferAllocator, 4096);
    }

    public static BinaryWriter newHeapInstance(BufferAllocator bufferAllocator, int n) {
        return BinaryWriter.isUnsafeHeapSupported() ? BinaryWriter.newUnsafeHeapInstance(bufferAllocator, n) : BinaryWriter.newSafeHeapInstance(bufferAllocator, n);
    }

    public static BinaryWriter newDirectInstance(BufferAllocator bufferAllocator) {
        return BinaryWriter.newDirectInstance(bufferAllocator, 4096);
    }

    public static BinaryWriter newDirectInstance(BufferAllocator bufferAllocator, int n) {
        return BinaryWriter.isUnsafeDirectSupported() ? BinaryWriter.newUnsafeDirectInstance(bufferAllocator, n) : BinaryWriter.newSafeDirectInstance(bufferAllocator, n);
    }

    static boolean isUnsafeHeapSupported() {
        return UnsafeHeapWriter.isSupported();
    }

    static boolean isUnsafeDirectSupported() {
        return UnsafeDirectWriter.isSupported();
    }

    static BinaryWriter newSafeHeapInstance(BufferAllocator bufferAllocator, int n) {
        return new SafeHeapWriter(bufferAllocator, n);
    }

    static BinaryWriter newUnsafeHeapInstance(BufferAllocator bufferAllocator, int n) {
        if (!BinaryWriter.isUnsafeHeapSupported()) {
            throw new UnsupportedOperationException("Unsafe operations not supported");
        }
        return new UnsafeHeapWriter(bufferAllocator, n);
    }

    static BinaryWriter newSafeDirectInstance(BufferAllocator bufferAllocator, int n) {
        return new SafeDirectWriter(bufferAllocator, n);
    }

    static BinaryWriter newUnsafeDirectInstance(BufferAllocator bufferAllocator, int n) {
        if (!BinaryWriter.isUnsafeDirectSupported()) {
            throw new UnsupportedOperationException("Unsafe operations not supported");
        }
        return new UnsafeDirectWriter(bufferAllocator, n);
    }

    private BinaryWriter(BufferAllocator bufferAllocator, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("chunkSize must be > 0");
        }
        this.alloc = Internal.checkNotNull(bufferAllocator, "alloc");
        this.chunkSize = n;
    }

    @Override
    public final Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.DESCENDING;
    }

    @CanIgnoreReturnValue
    public final Queue<AllocatedBuffer> complete() {
        this.finishCurrentBuffer();
        return this.buffers;
    }

    @Override
    public final void writeSFixed32(int n, int n2) throws IOException {
        this.writeFixed32(n, n2);
    }

    @Override
    public final void writeInt64(int n, long l) throws IOException {
        this.writeUInt64(n, l);
    }

    @Override
    public final void writeSFixed64(int n, long l) throws IOException {
        this.writeFixed64(n, l);
    }

    @Override
    public final void writeFloat(int n, float f) throws IOException {
        this.writeFixed32(n, Float.floatToRawIntBits(f));
    }

    @Override
    public final void writeDouble(int n, double d) throws IOException {
        this.writeFixed64(n, Double.doubleToRawLongBits(d));
    }

    @Override
    public final void writeEnum(int n, int n2) throws IOException {
        this.writeInt32(n, n2);
    }

    @Override
    public final void writeInt32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeInt32List_Internal(n, (IntArrayList)list, bl);
        } else {
            this.writeInt32List_Internal(n, list, bl);
        }
    }

    private void writeInt32List_Internal(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 10);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeInt32(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeInt32(n, list.get(i));
            }
        }
    }

    private void writeInt32List_Internal(int n, IntArrayList intArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + intArrayList.size() * 10);
            int n3 = this.getTotalBytesWritten();
            for (n2 = intArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeInt32(intArrayList.getInt(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = intArrayList.size() - 1; i >= 0; --i) {
                this.writeInt32(n, intArrayList.getInt(i));
            }
        }
    }

    @Override
    public final void writeFixed32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeFixed32List_Internal(n, (IntArrayList)list, bl);
        } else {
            this.writeFixed32List_Internal(n, list, bl);
        }
    }

    private void writeFixed32List_Internal(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 4);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeFixed32(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed32(n, list.get(i));
            }
        }
    }

    private void writeFixed32List_Internal(int n, IntArrayList intArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + intArrayList.size() * 4);
            int n3 = this.getTotalBytesWritten();
            for (n2 = intArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeFixed32(intArrayList.getInt(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = intArrayList.size() - 1; i >= 0; --i) {
                this.writeFixed32(n, intArrayList.getInt(i));
            }
        }
    }

    @Override
    public final void writeInt64List(int n, List<Long> list, boolean bl) throws IOException {
        this.writeUInt64List(n, list, bl);
    }

    @Override
    public final void writeUInt64List(int n, List<Long> list, boolean bl) throws IOException {
        if (list instanceof LongArrayList) {
            this.writeUInt64List_Internal(n, (LongArrayList)list, bl);
        } else {
            this.writeUInt64List_Internal(n, list, bl);
        }
    }

    private void writeUInt64List_Internal(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 10);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeVarint64(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeUInt64(n, list.get(i));
            }
        }
    }

    private void writeUInt64List_Internal(int n, LongArrayList longArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + longArrayList.size() * 10);
            int n3 = this.getTotalBytesWritten();
            for (n2 = longArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeVarint64(longArrayList.getLong(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = longArrayList.size() - 1; i >= 0; --i) {
                this.writeUInt64(n, longArrayList.getLong(i));
            }
        }
    }

    @Override
    public final void writeFixed64List(int n, List<Long> list, boolean bl) throws IOException {
        if (list instanceof LongArrayList) {
            this.writeFixed64List_Internal(n, (LongArrayList)list, bl);
        } else {
            this.writeFixed64List_Internal(n, list, bl);
        }
    }

    private void writeFixed64List_Internal(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 8);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeFixed64(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed64(n, list.get(i));
            }
        }
    }

    private void writeFixed64List_Internal(int n, LongArrayList longArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + longArrayList.size() * 8);
            int n3 = this.getTotalBytesWritten();
            for (n2 = longArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeFixed64(longArrayList.getLong(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = longArrayList.size() - 1; i >= 0; --i) {
                this.writeFixed64(n, longArrayList.getLong(i));
            }
        }
    }

    @Override
    public final void writeFloatList(int n, List<Float> list, boolean bl) throws IOException {
        if (list instanceof FloatArrayList) {
            this.writeFloatList_Internal(n, (FloatArrayList)list, bl);
        } else {
            this.writeFloatList_Internal(n, list, bl);
        }
    }

    private void writeFloatList_Internal(int n, List<Float> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 4);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeFixed32(Float.floatToRawIntBits(list.get(n2).floatValue()));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFloat(n, list.get(i).floatValue());
            }
        }
    }

    private void writeFloatList_Internal(int n, FloatArrayList floatArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + floatArrayList.size() * 4);
            int n3 = this.getTotalBytesWritten();
            for (n2 = floatArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeFixed32(Float.floatToRawIntBits(floatArrayList.getFloat(n2)));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = floatArrayList.size() - 1; i >= 0; --i) {
                this.writeFloat(n, floatArrayList.getFloat(i));
            }
        }
    }

    @Override
    public final void writeDoubleList(int n, List<Double> list, boolean bl) throws IOException {
        if (list instanceof DoubleArrayList) {
            this.writeDoubleList_Internal(n, (DoubleArrayList)list, bl);
        } else {
            this.writeDoubleList_Internal(n, list, bl);
        }
    }

    private void writeDoubleList_Internal(int n, List<Double> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 8);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeFixed64(Double.doubleToRawLongBits(list.get(n2)));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeDouble(n, list.get(i));
            }
        }
    }

    private void writeDoubleList_Internal(int n, DoubleArrayList doubleArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + doubleArrayList.size() * 8);
            int n3 = this.getTotalBytesWritten();
            for (n2 = doubleArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeFixed64(Double.doubleToRawLongBits(doubleArrayList.getDouble(n2)));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = doubleArrayList.size() - 1; i >= 0; --i) {
                this.writeDouble(n, doubleArrayList.getDouble(i));
            }
        }
    }

    @Override
    public final void writeEnumList(int n, List<Integer> list, boolean bl) throws IOException {
        this.writeInt32List(n, list, bl);
    }

    @Override
    public final void writeBoolList(int n, List<Boolean> list, boolean bl) throws IOException {
        if (list instanceof BooleanArrayList) {
            this.writeBoolList_Internal(n, (BooleanArrayList)list, bl);
        } else {
            this.writeBoolList_Internal(n, list, bl);
        }
    }

    private void writeBoolList_Internal(int n, List<Boolean> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size());
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeBool(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeBool(n, list.get(i));
            }
        }
    }

    private void writeBoolList_Internal(int n, BooleanArrayList booleanArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + booleanArrayList.size());
            int n3 = this.getTotalBytesWritten();
            for (n2 = booleanArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeBool(booleanArrayList.getBoolean(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = booleanArrayList.size() - 1; i >= 0; --i) {
                this.writeBool(n, booleanArrayList.getBoolean(i));
            }
        }
    }

    @Override
    public final void writeStringList(int n, List<String> list) throws IOException {
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeLazyString(n, lazyStringList.getRaw(i));
            }
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeString(n, list.get(i));
            }
        }
    }

    private void writeLazyString(int n, Object object) throws IOException {
        if (object instanceof String) {
            this.writeString(n, (String)object);
        } else {
            this.writeBytes(n, (ByteString)object);
        }
    }

    @Override
    public final void writeBytesList(int n, List<ByteString> list) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeBytes(n, list.get(i));
        }
    }

    @Override
    public final void writeUInt32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeUInt32List_Internal(n, (IntArrayList)list, bl);
        } else {
            this.writeUInt32List_Internal(n, list, bl);
        }
    }

    private void writeUInt32List_Internal(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 5);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeVarint32(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeUInt32(n, list.get(i));
            }
        }
    }

    private void writeUInt32List_Internal(int n, IntArrayList intArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + intArrayList.size() * 5);
            int n3 = this.getTotalBytesWritten();
            for (n2 = intArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeVarint32(intArrayList.getInt(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = intArrayList.size() - 1; i >= 0; --i) {
                this.writeUInt32(n, intArrayList.getInt(i));
            }
        }
    }

    @Override
    public final void writeSFixed32List(int n, List<Integer> list, boolean bl) throws IOException {
        this.writeFixed32List(n, list, bl);
    }

    @Override
    public final void writeSFixed64List(int n, List<Long> list, boolean bl) throws IOException {
        this.writeFixed64List(n, list, bl);
    }

    @Override
    public final void writeSInt32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (list instanceof IntArrayList) {
            this.writeSInt32List_Internal(n, (IntArrayList)list, bl);
        } else {
            this.writeSInt32List_Internal(n, list, bl);
        }
    }

    private void writeSInt32List_Internal(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 5);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeSInt32(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeSInt32(n, list.get(i));
            }
        }
    }

    private void writeSInt32List_Internal(int n, IntArrayList intArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + intArrayList.size() * 5);
            int n3 = this.getTotalBytesWritten();
            for (n2 = intArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeSInt32(intArrayList.getInt(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = intArrayList.size() - 1; i >= 0; --i) {
                this.writeSInt32(n, intArrayList.getInt(i));
            }
        }
    }

    @Override
    public final void writeSInt64List(int n, List<Long> list, boolean bl) throws IOException {
        if (list instanceof LongArrayList) {
            this.writeSInt64List_Internal(n, (LongArrayList)list, bl);
        } else {
            this.writeSInt64List_Internal(n, list, bl);
        }
    }

    @Override
    public <K, V> void writeMap(int n, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int n2 = this.getTotalBytesWritten();
            BinaryWriter.writeMapEntryField(this, 2, metadata.valueType, entry.getValue());
            BinaryWriter.writeMapEntryField(this, 1, metadata.keyType, entry.getKey());
            int n3 = this.getTotalBytesWritten() - n2;
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }
    }

    static final void writeMapEntryField(Writer writer, int n, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case BOOL: {
                writer.writeBool(n, (Boolean)object);
                break;
            }
            case FIXED32: {
                writer.writeFixed32(n, (Integer)object);
                break;
            }
            case FIXED64: {
                writer.writeFixed64(n, (Long)object);
                break;
            }
            case INT32: {
                writer.writeInt32(n, (Integer)object);
                break;
            }
            case INT64: {
                writer.writeInt64(n, (Long)object);
                break;
            }
            case SFIXED32: {
                writer.writeSFixed32(n, (Integer)object);
                break;
            }
            case SFIXED64: {
                writer.writeSFixed64(n, (Long)object);
                break;
            }
            case SINT32: {
                writer.writeSInt32(n, (Integer)object);
                break;
            }
            case SINT64: {
                writer.writeSInt64(n, (Long)object);
                break;
            }
            case STRING: {
                writer.writeString(n, (String)object);
                break;
            }
            case UINT32: {
                writer.writeUInt32(n, (Integer)object);
                break;
            }
            case UINT64: {
                writer.writeUInt64(n, (Long)object);
                break;
            }
            case FLOAT: {
                writer.writeFloat(n, ((Float)object).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble(n, (Double)object);
                break;
            }
            case MESSAGE: {
                writer.writeMessage(n, object);
                break;
            }
            case BYTES: {
                writer.writeBytes(n, (ByteString)object);
                break;
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    writer.writeEnum(n, ((Internal.EnumLite)object).getNumber());
                    break;
                }
                if (object instanceof Integer) {
                    writer.writeEnum(n, (Integer)object);
                    break;
                }
                throw new IllegalArgumentException("Unexpected type for enum in map.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported map value type for: " + (Object)((Object)fieldType));
            }
        }
    }

    private void writeSInt64List_Internal(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + list.size() * 10);
            int n3 = this.getTotalBytesWritten();
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                this.writeSInt64(list.get(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeSInt64(n, list.get(i));
            }
        }
    }

    private void writeSInt64List_Internal(int n, LongArrayList longArrayList, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.requireSpace(10 + longArrayList.size() * 10);
            int n3 = this.getTotalBytesWritten();
            for (n2 = longArrayList.size() - 1; n2 >= 0; --n2) {
                this.writeSInt64(longArrayList.getLong(n2));
            }
            n2 = this.getTotalBytesWritten() - n3;
            this.writeVarint32(n2);
            this.writeTag(n, 2);
        } else {
            for (int i = longArrayList.size() - 1; i >= 0; --i) {
                this.writeSInt64(n, longArrayList.getLong(i));
            }
        }
    }

    @Override
    public final void writeMessageList(int n, List<?> list) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeMessage(n, list.get(i));
        }
    }

    @Override
    public final void writeMessageList(int n, List<?> list, Schema schema) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeMessage(n, list.get(i), schema);
        }
    }

    @Override
    @Deprecated
    public final void writeGroupList(int n, List<?> list) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeGroup(n, list.get(i));
        }
    }

    @Override
    @Deprecated
    public final void writeGroupList(int n, List<?> list, Schema schema) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeGroup(n, list.get(i), schema);
        }
    }

    @Override
    public final void writeMessageSetItem(int n, Object object) throws IOException {
        this.writeTag(1, 4);
        if (object instanceof ByteString) {
            this.writeBytes(3, (ByteString)object);
        } else {
            this.writeMessage(3, object);
        }
        this.writeUInt32(2, n);
        this.writeTag(1, 3);
    }

    final AllocatedBuffer newHeapBuffer() {
        return this.alloc.allocateHeapBuffer(this.chunkSize);
    }

    final AllocatedBuffer newHeapBuffer(int n) {
        return this.alloc.allocateHeapBuffer(Math.max(n, this.chunkSize));
    }

    final AllocatedBuffer newDirectBuffer() {
        return this.alloc.allocateDirectBuffer(this.chunkSize);
    }

    final AllocatedBuffer newDirectBuffer(int n) {
        return this.alloc.allocateDirectBuffer(Math.max(n, this.chunkSize));
    }

    public abstract int getTotalBytesWritten();

    abstract void requireSpace(int var1);

    abstract void finishCurrentBuffer();

    abstract void writeTag(int var1, int var2);

    abstract void writeVarint32(int var1);

    abstract void writeInt32(int var1);

    abstract void writeSInt32(int var1);

    abstract void writeFixed32(int var1);

    abstract void writeVarint64(long var1);

    abstract void writeSInt64(long var1);

    abstract void writeFixed64(long var1);

    abstract void writeBool(boolean var1);

    abstract void writeString(String var1);

    private static byte computeUInt64SizeNoTag(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        byte by = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            by = (byte)(by + 4);
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            by = (byte)(by + 2);
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            by = (byte)(by + 1);
        }
        return by;
    }

    private static final class UnsafeDirectWriter
    extends BinaryWriter {
        private ByteBuffer buffer;
        private long bufferOffset;
        private long limitMinusOne;
        private long pos;

        UnsafeDirectWriter(BufferAllocator bufferAllocator, int n) {
            super(bufferAllocator, n);
            this.nextBuffer();
        }

        private static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        private void nextBuffer() {
            this.nextBuffer(this.newDirectBuffer());
        }

        private void nextBuffer(int n) {
            this.nextBuffer(this.newDirectBuffer(n));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasNioBuffer()) {
                throw new RuntimeException("Allocated buffer does not have NIO buffer");
            }
            ByteBuffer byteBuffer = allocatedBuffer.nioBuffer();
            if (!byteBuffer.isDirect()) {
                throw new RuntimeException("Allocator returned non-direct buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.buffer = byteBuffer;
            Java8Compatibility.limit(this.buffer, this.buffer.capacity());
            Java8Compatibility.position(this.buffer, 0);
            this.bufferOffset = UnsafeUtil.addressOffset(this.buffer);
            this.pos = this.limitMinusOne = this.bufferOffset + (long)(this.buffer.limit() - 1);
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        private int bytesWrittenToCurrentBuffer() {
            return (int)(this.limitMinusOne - this.pos);
        }

        private int spaceLeft() {
            return this.bufferPos() + 1;
        }

        @Override
        void finishCurrentBuffer() {
            if (this.buffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
                this.buffer = null;
                this.pos = 0L;
                this.limitMinusOne = 0L;
            }
        }

        private int bufferPos() {
            return (int)(this.pos - this.bufferOffset);
        }

        @Override
        public void writeUInt32(int n, int n2) {
            this.requireSpace(10);
            this.writeVarint32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeInt32(int n, int n2) {
            this.requireSpace(15);
            this.writeInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt32(int n, int n2) {
            this.requireSpace(10);
            this.writeSInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed32(int n, int n2) {
            this.requireSpace(9);
            this.writeFixed32(n2);
            this.writeTag(n, 5);
        }

        @Override
        public void writeUInt64(int n, long l) {
            this.requireSpace(15);
            this.writeVarint64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt64(int n, long l) {
            this.requireSpace(15);
            this.writeSInt64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed64(int n, long l) {
            this.requireSpace(13);
            this.writeFixed64(l);
            this.writeTag(n, 1);
        }

        @Override
        public void writeBool(int n, boolean bl) {
            this.requireSpace(6);
            this.write((byte)(bl ? 1 : 0));
            this.writeTag(n, 0);
        }

        @Override
        public void writeString(int n, String string) {
            int n2 = this.getTotalBytesWritten();
            this.writeString(string);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object) throws IOException {
            int n2 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object, Schema schema) throws IOException {
            int n2 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeGroup(int n, Object object) throws IOException {
            this.writeTag(n, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        public void writeGroup(int n, Object object, Schema schema) throws IOException {
            this.writeTag(n, 4);
            schema.writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        @Deprecated
        public void writeStartGroup(int n) {
            this.writeTag(n, 3);
        }

        @Override
        @Deprecated
        public void writeEndGroup(int n) {
            this.writeTag(n, 4);
        }

        @Override
        void writeInt32(int n) {
            if (n >= 0) {
                this.writeVarint32(n);
            } else {
                this.writeVarint64(n);
            }
        }

        @Override
        void writeSInt32(int n) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n));
        }

        @Override
        void writeSInt64(long l) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l));
        }

        @Override
        void writeBool(boolean bl) {
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        void writeTag(int n, int n2) {
            this.writeVarint32(WireFormat.makeTag(n, n2));
        }

        @Override
        void writeVarint32(int n) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n);
            } else if ((n & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n);
            } else if ((n & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n);
            } else if ((n & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n);
            } else {
                this.writeVarint32FiveBytes(n);
            }
        }

        private void writeVarint32OneByte(int n) {
            UnsafeUtil.putByte(this.pos--, (byte)n);
        }

        private void writeVarint32TwoBytes(int n) {
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 7));
            UnsafeUtil.putByte(this.pos--, (byte)(n & 0x7F | 0x80));
        }

        private void writeVarint32ThreeBytes(int n) {
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 14));
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n & 0x7F | 0x80));
        }

        private void writeVarint32FourBytes(int n) {
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 21));
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n & 0x7F | 0x80));
        }

        private void writeVarint32FiveBytes(int n) {
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 28));
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 21 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(n & 0x7F | 0x80));
        }

        @Override
        void writeVarint64(long l) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l)) {
                case 1: {
                    this.writeVarint64OneByte(l);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l);
                }
            }
        }

        private void writeVarint64OneByte(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)l);
        }

        private void writeVarint64TwoBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7));
            UnsafeUtil.putByte(this.pos--, (byte)((int)l & 0x7F | 0x80));
        }

        private void writeVarint64ThreeBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)((int)l >>> 14));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64FourBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64FiveBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 28));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64SixBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 35));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64SevenBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 42));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64EightBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 49));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64NineBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 56));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64TenBytes(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 63));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 56 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        @Override
        void writeFixed32(int n) {
            UnsafeUtil.putByte(this.pos--, (byte)(n >> 24 & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)(n >> 16 & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)(n >> 8 & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)(n & 0xFF));
        }

        @Override
        void writeFixed64(long l) {
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 56) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 48) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 40) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 32) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 24) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 16) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)(l >> 8) & 0xFF));
            UnsafeUtil.putByte(this.pos--, (byte)((int)l & 0xFF));
        }

        @Override
        void writeString(String string) {
            char c;
            int n;
            this.requireSpace(string.length());
            for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) < '\u0080'; --n) {
                UnsafeUtil.putByte(this.pos--, (byte)c);
            }
            if (n == -1) {
                return;
            }
            while (n >= 0) {
                c = string.charAt(n);
                if (c < '\u0080' && this.pos >= this.bufferOffset) {
                    UnsafeUtil.putByte(this.pos--, (byte)c);
                } else if (c < '\u0800' && this.pos > this.bufferOffset) {
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x3C0 | c >>> 6));
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > this.bufferOffset + 1L) {
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x1E0 | c >>> 12));
                } else if (this.pos > this.bufferOffset + 2L) {
                    char c2;
                    if (n == 0 || !Character.isSurrogatePair(c2 = string.charAt(n - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(n - 1, n);
                    }
                    --n;
                    int n2 = Character.toCodePoint(c2, c);
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & n2));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & n2 >>> 6));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & n2 >>> 12));
                    UnsafeUtil.putByte(this.pos--, (byte)(0xF0 | n2 >>> 18));
                } else {
                    this.requireSpace(n);
                    ++n;
                }
                --n;
            }
        }

        @Override
        public void write(byte by) {
            UnsafeUtil.putByte(this.pos--, by);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
            this.pos -= (long)n2;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put(byArray, n, n2);
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) {
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n, n2));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)n2;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put(byArray, n, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
            this.pos -= (long)n;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.totalDoneBytes += n;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)n;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        void requireSpace(int n) {
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
        }
    }

    private static final class SafeDirectWriter
    extends BinaryWriter {
        private ByteBuffer buffer;
        private int limitMinusOne;
        private int pos;

        SafeDirectWriter(BufferAllocator bufferAllocator, int n) {
            super(bufferAllocator, n);
            this.nextBuffer();
        }

        private void nextBuffer() {
            this.nextBuffer(this.newDirectBuffer());
        }

        private void nextBuffer(int n) {
            this.nextBuffer(this.newDirectBuffer(n));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasNioBuffer()) {
                throw new RuntimeException("Allocated buffer does not have NIO buffer");
            }
            ByteBuffer byteBuffer = allocatedBuffer.nioBuffer();
            if (!byteBuffer.isDirect()) {
                throw new RuntimeException("Allocator returned non-direct buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.buffer = byteBuffer;
            Java8Compatibility.limit(this.buffer, this.buffer.capacity());
            Java8Compatibility.position(this.buffer, 0);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.pos = this.limitMinusOne = this.buffer.limit() - 1;
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        private int bytesWrittenToCurrentBuffer() {
            return this.limitMinusOne - this.pos;
        }

        private int spaceLeft() {
            return this.pos + 1;
        }

        @Override
        void finishCurrentBuffer() {
            if (this.buffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                Java8Compatibility.position(this.buffer, this.pos + 1);
                this.buffer = null;
                this.pos = 0;
                this.limitMinusOne = 0;
            }
        }

        @Override
        public void writeUInt32(int n, int n2) {
            this.requireSpace(10);
            this.writeVarint32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeInt32(int n, int n2) {
            this.requireSpace(15);
            this.writeInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt32(int n, int n2) {
            this.requireSpace(10);
            this.writeSInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed32(int n, int n2) {
            this.requireSpace(9);
            this.writeFixed32(n2);
            this.writeTag(n, 5);
        }

        @Override
        public void writeUInt64(int n, long l) {
            this.requireSpace(15);
            this.writeVarint64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt64(int n, long l) {
            this.requireSpace(15);
            this.writeSInt64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed64(int n, long l) {
            this.requireSpace(13);
            this.writeFixed64(l);
            this.writeTag(n, 1);
        }

        @Override
        public void writeBool(int n, boolean bl) {
            this.requireSpace(6);
            this.write((byte)(bl ? 1 : 0));
            this.writeTag(n, 0);
        }

        @Override
        public void writeString(int n, String string) {
            int n2 = this.getTotalBytesWritten();
            this.writeString(string);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object) throws IOException {
            int n2 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object, Schema schema) throws IOException {
            int n2 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        @Deprecated
        public void writeGroup(int n, Object object) throws IOException {
            this.writeTag(n, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        public void writeGroup(int n, Object object, Schema schema) throws IOException {
            this.writeTag(n, 4);
            schema.writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        @Deprecated
        public void writeStartGroup(int n) {
            this.writeTag(n, 3);
        }

        @Override
        @Deprecated
        public void writeEndGroup(int n) {
            this.writeTag(n, 4);
        }

        @Override
        void writeInt32(int n) {
            if (n >= 0) {
                this.writeVarint32(n);
            } else {
                this.writeVarint64(n);
            }
        }

        @Override
        void writeSInt32(int n) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n));
        }

        @Override
        void writeSInt64(long l) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l));
        }

        @Override
        void writeBool(boolean bl) {
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        void writeTag(int n, int n2) {
            this.writeVarint32(WireFormat.makeTag(n, n2));
        }

        @Override
        void writeVarint32(int n) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n);
            } else if ((n & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n);
            } else if ((n & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n);
            } else if ((n & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n);
            } else {
                this.writeVarint32FiveBytes(n);
            }
        }

        private void writeVarint32OneByte(int n) {
            this.buffer.put(this.pos--, (byte)n);
        }

        private void writeVarint32TwoBytes(int n) {
            this.pos -= 2;
            this.buffer.putShort(this.pos + 1, (short)((n & 0x3F80) << 1 | (n & 0x7F | 0x80)));
        }

        private void writeVarint32ThreeBytes(int n) {
            this.pos -= 3;
            this.buffer.putInt(this.pos, (n & 0x1FC000) << 10 | (n & 0x3F80 | 0x4000) << 9 | (n & 0x7F | 0x80) << 8);
        }

        private void writeVarint32FourBytes(int n) {
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (n & 0xFE00000) << 3 | (n & 0x1FC000 | 0x200000) << 2 | (n & 0x3F80 | 0x4000) << 1 | (n & 0x7F | 0x80));
        }

        private void writeVarint32FiveBytes(int n) {
            this.buffer.put(this.pos--, (byte)(n >>> 28));
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (n >>> 21 & 0x7F | 0x80) << 24 | (n >>> 14 & 0x7F | 0x80) << 16 | (n >>> 7 & 0x7F | 0x80) << 8 | (n & 0x7F | 0x80));
        }

        @Override
        void writeVarint64(long l) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l)) {
                case 1: {
                    this.writeVarint64OneByte(l);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l);
                }
            }
        }

        private void writeVarint64OneByte(long l) {
            this.writeVarint32OneByte((int)l);
        }

        private void writeVarint64TwoBytes(long l) {
            this.writeVarint32TwoBytes((int)l);
        }

        private void writeVarint64ThreeBytes(long l) {
            this.writeVarint32ThreeBytes((int)l);
        }

        private void writeVarint64FourBytes(long l) {
            this.writeVarint32FourBytes((int)l);
        }

        private void writeVarint64FiveBytes(long l) {
            this.pos -= 5;
            this.buffer.putLong(this.pos - 2, (l & 0x7F0000000L) << 28 | (l & 0xFE00000L | 0x10000000L) << 27 | (l & 0x1FC000L | 0x200000L) << 26 | (l & 0x3F80L | 0x4000L) << 25 | (l & 0x7FL | 0x80L) << 24);
        }

        private void writeVarint64SixBytes(long l) {
            this.pos -= 6;
            this.buffer.putLong(this.pos - 1, (l & 0x3F800000000L) << 21 | (l & 0x7F0000000L | 0x800000000L) << 20 | (l & 0xFE00000L | 0x10000000L) << 19 | (l & 0x1FC000L | 0x200000L) << 18 | (l & 0x3F80L | 0x4000L) << 17 | (l & 0x7FL | 0x80L) << 16);
        }

        private void writeVarint64SevenBytes(long l) {
            this.pos -= 7;
            this.buffer.putLong(this.pos, (l & 0x1FC0000000000L) << 14 | (l & 0x3F800000000L | 0x40000000000L) << 13 | (l & 0x7F0000000L | 0x800000000L) << 12 | (l & 0xFE00000L | 0x10000000L) << 11 | (l & 0x1FC000L | 0x200000L) << 10 | (l & 0x3F80L | 0x4000L) << 9 | (l & 0x7FL | 0x80L) << 8);
        }

        private void writeVarint64EightBytes(long l) {
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (l & 0xFE000000000000L) << 7 | (l & 0x1FC0000000000L | 0x2000000000000L) << 6 | (l & 0x3F800000000L | 0x40000000000L) << 5 | (l & 0x7F0000000L | 0x800000000L) << 4 | (l & 0xFE00000L | 0x10000000L) << 3 | (l & 0x1FC000L | 0x200000L) << 2 | (l & 0x3F80L | 0x4000L) << 1 | (l & 0x7FL | 0x80L));
        }

        private void writeVarint64EightBytesWithSign(long l) {
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (l & 0xFE000000000000L | 0x100000000000000L) << 7 | (l & 0x1FC0000000000L | 0x2000000000000L) << 6 | (l & 0x3F800000000L | 0x40000000000L) << 5 | (l & 0x7F0000000L | 0x800000000L) << 4 | (l & 0xFE00000L | 0x10000000L) << 3 | (l & 0x1FC000L | 0x200000L) << 2 | (l & 0x3F80L | 0x4000L) << 1 | (l & 0x7FL | 0x80L));
        }

        private void writeVarint64NineBytes(long l) {
            this.buffer.put(this.pos--, (byte)(l >>> 56));
            this.writeVarint64EightBytesWithSign(l & 0xFFFFFFFFFFFFFFL);
        }

        private void writeVarint64TenBytes(long l) {
            this.buffer.put(this.pos--, (byte)(l >>> 63));
            this.buffer.put(this.pos--, (byte)(l >>> 56 & 0x7FL | 0x80L));
            this.writeVarint64EightBytesWithSign(l & 0xFFFFFFFFFFFFFFL);
        }

        @Override
        void writeFixed32(int n) {
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, n);
        }

        @Override
        void writeFixed64(long l) {
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, l);
        }

        @Override
        void writeString(String string) {
            char c;
            int n;
            this.requireSpace(string.length());
            this.pos -= n;
            for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) < '\u0080'; --n) {
                this.buffer.put(this.pos + n, (byte)c);
            }
            if (n == -1) {
                --this.pos;
                return;
            }
            this.pos += n;
            while (n >= 0) {
                c = string.charAt(n);
                if (c < '\u0080' && this.pos >= 0) {
                    this.buffer.put(this.pos--, (byte)c);
                } else if (c < '\u0800' && this.pos > 0) {
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c));
                    this.buffer.put(this.pos--, (byte)(0x3C0 | c >>> 6));
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > 1) {
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c >>> 6));
                    this.buffer.put(this.pos--, (byte)(0x1E0 | c >>> 12));
                } else if (this.pos > 2) {
                    char c2 = '\u0000';
                    if (n == 0 || !Character.isSurrogatePair(c2 = string.charAt(n - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(n - 1, n);
                    }
                    --n;
                    int n2 = Character.toCodePoint(c2, c);
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & n2));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & n2 >>> 6));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & n2 >>> 12));
                    this.buffer.put(this.pos--, (byte)(0xF0 | n2 >>> 18));
                } else {
                    this.requireSpace(n);
                    ++n;
                }
                --n;
            }
        }

        @Override
        public void write(byte by) {
            this.buffer.put(this.pos--, by);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
            this.pos -= n2;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put(byArray, n, n2);
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) {
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n, n2));
                this.nextBuffer();
                return;
            }
            this.pos -= n2;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put(byArray, n, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
            this.pos -= n;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.totalDoneBytes += n;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
                return;
            }
            this.pos -= n;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put(byteBuffer);
        }

        @Override
        void requireSpace(int n) {
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
        }
    }

    private static final class UnsafeHeapWriter
    extends BinaryWriter {
        private AllocatedBuffer allocatedBuffer;
        private byte[] buffer;
        private long offset;
        private long limit;
        private long offsetMinusOne;
        private long limitMinusOne;
        private long pos;

        UnsafeHeapWriter(BufferAllocator bufferAllocator, int n) {
            super(bufferAllocator, n);
            this.nextBuffer();
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeArrayOperations();
        }

        @Override
        void finishCurrentBuffer() {
            if (this.allocatedBuffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.allocatedBuffer.position(this.arrayPos() - this.allocatedBuffer.arrayOffset() + 1);
                this.allocatedBuffer = null;
                this.pos = 0L;
                this.limitMinusOne = 0L;
            }
        }

        private int arrayPos() {
            return (int)this.pos;
        }

        private void nextBuffer() {
            this.nextBuffer(this.newHeapBuffer());
        }

        private void nextBuffer(int n) {
            this.nextBuffer(this.newHeapBuffer(n));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasArray()) {
                throw new RuntimeException("Allocator returned non-heap buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.allocatedBuffer = allocatedBuffer;
            this.buffer = allocatedBuffer.array();
            int n = allocatedBuffer.arrayOffset();
            this.limit = (long)n + (long)allocatedBuffer.limit();
            this.offset = (long)n + (long)allocatedBuffer.position();
            this.offsetMinusOne = this.offset - 1L;
            this.pos = this.limitMinusOne = this.limit - 1L;
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        int bytesWrittenToCurrentBuffer() {
            return (int)(this.limitMinusOne - this.pos);
        }

        int spaceLeft() {
            return (int)(this.pos - this.offsetMinusOne);
        }

        @Override
        public void writeUInt32(int n, int n2) {
            this.requireSpace(10);
            this.writeVarint32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeInt32(int n, int n2) {
            this.requireSpace(15);
            this.writeInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt32(int n, int n2) {
            this.requireSpace(10);
            this.writeSInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed32(int n, int n2) {
            this.requireSpace(9);
            this.writeFixed32(n2);
            this.writeTag(n, 5);
        }

        @Override
        public void writeUInt64(int n, long l) {
            this.requireSpace(15);
            this.writeVarint64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt64(int n, long l) {
            this.requireSpace(15);
            this.writeSInt64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed64(int n, long l) {
            this.requireSpace(13);
            this.writeFixed64(l);
            this.writeTag(n, 1);
        }

        @Override
        public void writeBool(int n, boolean bl) {
            this.requireSpace(6);
            this.write((byte)(bl ? 1 : 0));
            this.writeTag(n, 0);
        }

        @Override
        public void writeString(int n, String string) {
            int n2 = this.getTotalBytesWritten();
            this.writeString(string);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object) throws IOException {
            int n2 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object, Schema schema) throws IOException {
            int n2 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeGroup(int n, Object object) throws IOException {
            this.writeTag(n, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        public void writeGroup(int n, Object object, Schema schema) throws IOException {
            this.writeTag(n, 4);
            schema.writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        public void writeStartGroup(int n) {
            this.writeTag(n, 3);
        }

        @Override
        public void writeEndGroup(int n) {
            this.writeTag(n, 4);
        }

        @Override
        void writeInt32(int n) {
            if (n >= 0) {
                this.writeVarint32(n);
            } else {
                this.writeVarint64(n);
            }
        }

        @Override
        void writeSInt32(int n) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n));
        }

        @Override
        void writeSInt64(long l) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l));
        }

        @Override
        void writeBool(boolean bl) {
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        void writeTag(int n, int n2) {
            this.writeVarint32(WireFormat.makeTag(n, n2));
        }

        @Override
        void writeVarint32(int n) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n);
            } else if ((n & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n);
            } else if ((n & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n);
            } else if ((n & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n);
            } else {
                this.writeVarint32FiveBytes(n);
            }
        }

        private void writeVarint32OneByte(int n) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)n);
        }

        private void writeVarint32TwoBytes(int n) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 7));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n & 0x7F | 0x80));
        }

        private void writeVarint32ThreeBytes(int n) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 14));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n & 0x7F | 0x80));
        }

        private void writeVarint32FourBytes(int n) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 21));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n & 0x7F | 0x80));
        }

        private void writeVarint32FiveBytes(int n) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 28));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 21 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n & 0x7F | 0x80));
        }

        @Override
        void writeVarint64(long l) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l)) {
                case 1: {
                    this.writeVarint64OneByte(l);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l);
                }
            }
        }

        private void writeVarint64OneByte(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)l);
        }

        private void writeVarint64TwoBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)l & 0x7F | 0x80));
        }

        private void writeVarint64ThreeBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)l >>> 14));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64FourBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64FiveBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 28));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64SixBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 35));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64SevenBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 42));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64EightBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 49));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64NineBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 56));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        private void writeVarint64TenBytes(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 63));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 56 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(l & 0x7FL | 0x80L));
        }

        @Override
        void writeFixed32(int n) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >> 24 & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >> 16 & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n >> 8 & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(n & 0xFF));
        }

        @Override
        void writeFixed64(long l) {
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 56) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 48) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 40) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 32) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 24) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 16) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)(l >> 8) & 0xFF));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)l & 0xFF));
        }

        @Override
        void writeString(String string) {
            char c;
            int n;
            this.requireSpace(string.length());
            for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) < '\u0080'; --n) {
                UnsafeUtil.putByte(this.buffer, this.pos--, (byte)c);
            }
            if (n == -1) {
                return;
            }
            while (n >= 0) {
                c = string.charAt(n);
                if (c < '\u0080' && this.pos > this.offsetMinusOne) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)c);
                } else if (c < '\u0800' && this.pos > this.offset) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x3C0 | c >>> 6));
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > this.offset + 1L) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x1E0 | c >>> 12));
                } else if (this.pos > this.offset + 2L) {
                    char c2;
                    if (n == 0 || !Character.isSurrogatePair(c2 = string.charAt(n - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(n - 1, n);
                    }
                    --n;
                    int n2 = Character.toCodePoint(c2, c);
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & n2));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & n2 >>> 6));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & n2 >>> 12));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0xF0 | n2 >>> 18));
                } else {
                    this.requireSpace(n);
                    ++n;
                }
                --n;
            }
        }

        @Override
        public void write(byte by) {
            UnsafeUtil.putByte(this.buffer, this.pos--, by);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (n < 0 || n + n2 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("value.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.requireSpace(n2);
            this.pos -= (long)n2;
            System.arraycopy(byArray, n, this.buffer, this.arrayPos() + 1, n2);
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) {
            if (n < 0 || n + n2 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("value.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n, n2));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)n2;
            System.arraycopy(byArray, n, this.buffer, this.arrayPos() + 1, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            this.requireSpace(n);
            this.pos -= (long)n;
            byteBuffer.get(this.buffer, this.arrayPos() + 1, n);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.totalDoneBytes += n;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
            }
            this.pos -= (long)n;
            byteBuffer.get(this.buffer, this.arrayPos() + 1, n);
        }

        @Override
        void requireSpace(int n) {
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
        }
    }

    private static final class SafeHeapWriter
    extends BinaryWriter {
        private AllocatedBuffer allocatedBuffer;
        private byte[] buffer;
        private int offset;
        private int limit;
        private int offsetMinusOne;
        private int limitMinusOne;
        private int pos;

        SafeHeapWriter(BufferAllocator bufferAllocator, int n) {
            super(bufferAllocator, n);
            this.nextBuffer();
        }

        @Override
        void finishCurrentBuffer() {
            if (this.allocatedBuffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.allocatedBuffer.position(this.pos - this.allocatedBuffer.arrayOffset() + 1);
                this.allocatedBuffer = null;
                this.pos = 0;
                this.limitMinusOne = 0;
            }
        }

        private void nextBuffer() {
            this.nextBuffer(this.newHeapBuffer());
        }

        private void nextBuffer(int n) {
            this.nextBuffer(this.newHeapBuffer(n));
        }

        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            if (!allocatedBuffer.hasArray()) {
                throw new RuntimeException("Allocator returned non-heap buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.allocatedBuffer = allocatedBuffer;
            this.buffer = allocatedBuffer.array();
            int n = allocatedBuffer.arrayOffset();
            this.limit = n + allocatedBuffer.limit();
            this.offset = n + allocatedBuffer.position();
            this.offsetMinusOne = this.offset - 1;
            this.pos = this.limitMinusOne = this.limit - 1;
        }

        @Override
        public int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        int bytesWrittenToCurrentBuffer() {
            return this.limitMinusOne - this.pos;
        }

        int spaceLeft() {
            return this.pos - this.offsetMinusOne;
        }

        @Override
        public void writeUInt32(int n, int n2) throws IOException {
            this.requireSpace(10);
            this.writeVarint32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeInt32(int n, int n2) throws IOException {
            this.requireSpace(15);
            this.writeInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt32(int n, int n2) throws IOException {
            this.requireSpace(10);
            this.writeSInt32(n2);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed32(int n, int n2) throws IOException {
            this.requireSpace(9);
            this.writeFixed32(n2);
            this.writeTag(n, 5);
        }

        @Override
        public void writeUInt64(int n, long l) throws IOException {
            this.requireSpace(15);
            this.writeVarint64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeSInt64(int n, long l) throws IOException {
            this.requireSpace(15);
            this.writeSInt64(l);
            this.writeTag(n, 0);
        }

        @Override
        public void writeFixed64(int n, long l) throws IOException {
            this.requireSpace(13);
            this.writeFixed64(l);
            this.writeTag(n, 1);
        }

        @Override
        public void writeBool(int n, boolean bl) throws IOException {
            this.requireSpace(6);
            this.write((byte)(bl ? 1 : 0));
            this.writeTag(n, 0);
        }

        @Override
        public void writeString(int n, String string) throws IOException {
            int n2 = this.getTotalBytesWritten();
            this.writeString(string);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) throws IOException {
            try {
                byteString.writeToReverse(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.requireSpace(10);
            this.writeVarint32(byteString.size());
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object) throws IOException {
            int n2 = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        public void writeMessage(int n, Object object, Schema schema) throws IOException {
            int n2 = this.getTotalBytesWritten();
            schema.writeTo(object, this);
            int n3 = this.getTotalBytesWritten() - n2;
            this.requireSpace(10);
            this.writeVarint32(n3);
            this.writeTag(n, 2);
        }

        @Override
        @Deprecated
        public void writeGroup(int n, Object object) throws IOException {
            this.writeTag(n, 4);
            Protobuf.getInstance().writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        public void writeGroup(int n, Object object, Schema schema) throws IOException {
            this.writeTag(n, 4);
            schema.writeTo(object, this);
            this.writeTag(n, 3);
        }

        @Override
        public void writeStartGroup(int n) {
            this.writeTag(n, 3);
        }

        @Override
        public void writeEndGroup(int n) {
            this.writeTag(n, 4);
        }

        @Override
        void writeInt32(int n) {
            if (n >= 0) {
                this.writeVarint32(n);
            } else {
                this.writeVarint64(n);
            }
        }

        @Override
        void writeSInt32(int n) {
            this.writeVarint32(CodedOutputStream.encodeZigZag32(n));
        }

        @Override
        void writeSInt64(long l) {
            this.writeVarint64(CodedOutputStream.encodeZigZag64(l));
        }

        @Override
        void writeBool(boolean bl) {
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        void writeTag(int n, int n2) {
            this.writeVarint32(WireFormat.makeTag(n, n2));
        }

        @Override
        void writeVarint32(int n) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(n);
            } else if ((n & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(n);
            } else if ((n & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(n);
            } else if ((n & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(n);
            } else {
                this.writeVarint32FiveBytes(n);
            }
        }

        private void writeVarint32OneByte(int n) {
            this.buffer[this.pos--] = (byte)n;
        }

        private void writeVarint32TwoBytes(int n) {
            this.buffer[this.pos--] = (byte)(n >>> 7);
            this.buffer[this.pos--] = (byte)(n & 0x7F | 0x80);
        }

        private void writeVarint32ThreeBytes(int n) {
            this.buffer[this.pos--] = (byte)(n >>> 14);
            this.buffer[this.pos--] = (byte)(n >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n & 0x7F | 0x80);
        }

        private void writeVarint32FourBytes(int n) {
            this.buffer[this.pos--] = (byte)(n >>> 21);
            this.buffer[this.pos--] = (byte)(n >>> 14 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n & 0x7F | 0x80);
        }

        private void writeVarint32FiveBytes(int n) {
            this.buffer[this.pos--] = (byte)(n >>> 28);
            this.buffer[this.pos--] = (byte)(n >>> 21 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n >>> 14 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(n & 0x7F | 0x80);
        }

        @Override
        void writeVarint64(long l) {
            switch (BinaryWriter.computeUInt64SizeNoTag(l)) {
                case 1: {
                    this.writeVarint64OneByte(l);
                    break;
                }
                case 2: {
                    this.writeVarint64TwoBytes(l);
                    break;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(l);
                    break;
                }
                case 4: {
                    this.writeVarint64FourBytes(l);
                    break;
                }
                case 5: {
                    this.writeVarint64FiveBytes(l);
                    break;
                }
                case 6: {
                    this.writeVarint64SixBytes(l);
                    break;
                }
                case 7: {
                    this.writeVarint64SevenBytes(l);
                    break;
                }
                case 8: {
                    this.writeVarint64EightBytes(l);
                    break;
                }
                case 9: {
                    this.writeVarint64NineBytes(l);
                    break;
                }
                case 10: {
                    this.writeVarint64TenBytes(l);
                }
            }
        }

        private void writeVarint64OneByte(long l) {
            this.buffer[this.pos--] = (byte)l;
        }

        private void writeVarint64TwoBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 7);
            this.buffer[this.pos--] = (byte)((int)l & 0x7F | 0x80);
        }

        private void writeVarint64ThreeBytes(long l) {
            this.buffer[this.pos--] = (byte)((int)l >>> 14);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64FourBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 21);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64FiveBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 28);
            this.buffer[this.pos--] = (byte)(l >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64SixBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 35);
            this.buffer[this.pos--] = (byte)(l >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64SevenBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 42);
            this.buffer[this.pos--] = (byte)(l >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64EightBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 49);
            this.buffer[this.pos--] = (byte)(l >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64NineBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 56);
            this.buffer[this.pos--] = (byte)(l >>> 49 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        private void writeVarint64TenBytes(long l) {
            this.buffer[this.pos--] = (byte)(l >>> 63);
            this.buffer[this.pos--] = (byte)(l >>> 56 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 49 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(l & 0x7FL | 0x80L);
        }

        @Override
        void writeFixed32(int n) {
            this.buffer[this.pos--] = (byte)(n >> 24 & 0xFF);
            this.buffer[this.pos--] = (byte)(n >> 16 & 0xFF);
            this.buffer[this.pos--] = (byte)(n >> 8 & 0xFF);
            this.buffer[this.pos--] = (byte)(n & 0xFF);
        }

        @Override
        void writeFixed64(long l) {
            this.buffer[this.pos--] = (byte)((int)(l >> 56) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l >> 48) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l >> 40) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l >> 32) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l >> 24) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l >> 16) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)(l >> 8) & 0xFF);
            this.buffer[this.pos--] = (byte)((int)l & 0xFF);
        }

        @Override
        void writeString(String string) {
            char c;
            int n;
            this.requireSpace(string.length());
            this.pos -= n;
            for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) < '\u0080'; --n) {
                this.buffer[this.pos + n] = (byte)c;
            }
            if (n == -1) {
                --this.pos;
                return;
            }
            this.pos += n;
            while (n >= 0) {
                c = string.charAt(n);
                if (c < '\u0080' && this.pos > this.offsetMinusOne) {
                    this.buffer[this.pos--] = (byte)c;
                } else if (c < '\u0800' && this.pos > this.offset) {
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c);
                    this.buffer[this.pos--] = (byte)(0x3C0 | c >>> 6);
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > this.offset + 1) {
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c >>> 6);
                    this.buffer[this.pos--] = (byte)(0x1E0 | c >>> 12);
                } else if (this.pos > this.offset + 2) {
                    char c2 = '\u0000';
                    if (n == 0 || !Character.isSurrogatePair(c2 = string.charAt(n - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(n - 1, n);
                    }
                    --n;
                    int n2 = Character.toCodePoint(c2, c);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & n2);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & n2 >>> 6);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & n2 >>> 12);
                    this.buffer[this.pos--] = (byte)(0xF0 | n2 >>> 18);
                } else {
                    this.requireSpace(n);
                    ++n;
                }
                --n;
            }
        }

        @Override
        public void write(byte by) {
            this.buffer[this.pos--] = by;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (this.spaceLeft() < n2) {
                this.nextBuffer(n2);
            }
            this.pos -= n2;
            System.arraycopy(byArray, n, this.buffer, this.pos + 1, n2);
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) {
            if (this.spaceLeft() < n2) {
                this.totalDoneBytes += n2;
                this.buffers.addFirst(AllocatedBuffer.wrap(byArray, n, n2));
                this.nextBuffer();
                return;
            }
            this.pos -= n2;
            System.arraycopy(byArray, n, this.buffer, this.pos + 1, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
            this.pos -= n;
            byteBuffer.get(this.buffer, this.pos + 1, n);
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (this.spaceLeft() < n) {
                this.totalDoneBytes += n;
                this.buffers.addFirst(AllocatedBuffer.wrap(byteBuffer));
                this.nextBuffer();
            }
            this.pos -= n;
            byteBuffer.get(this.buffer, this.pos + 1, n);
        }

        @Override
        void requireSpace(int n) {
            if (this.spaceLeft() < n) {
                this.nextBuffer(n);
            }
        }
    }
}

