/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.CanIgnoreReturnValue;
import com.mathworks.google.protobuf.CheckReturnValue;
import com.mathworks.google.protobuf.Internal;
import com.mathworks.google.protobuf.Java8Compatibility;
import java.nio.ByteBuffer;

@CheckReturnValue
abstract class AllocatedBuffer {
    AllocatedBuffer() {
    }

    public abstract boolean hasNioBuffer();

    public abstract boolean hasArray();

    public abstract ByteBuffer nioBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract int position();

    @CanIgnoreReturnValue
    public abstract AllocatedBuffer position(int var1);

    public abstract int limit();

    public abstract int remaining();

    public static AllocatedBuffer wrap(byte[] byArray) {
        return AllocatedBuffer.wrapNoCheck(byArray, 0, byArray.length);
    }

    public static AllocatedBuffer wrap(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException(String.format("bytes.length=%d, offset=%d, length=%d", byArray.length, n, n2));
        }
        return AllocatedBuffer.wrapNoCheck(byArray, n, n2);
    }

    public static AllocatedBuffer wrap(final ByteBuffer byteBuffer) {
        Internal.checkNotNull(byteBuffer, "buffer");
        return new AllocatedBuffer(){

            @Override
            public boolean hasNioBuffer() {
                return true;
            }

            @Override
            public ByteBuffer nioBuffer() {
                return byteBuffer;
            }

            @Override
            public boolean hasArray() {
                return byteBuffer.hasArray();
            }

            @Override
            public byte[] array() {
                return byteBuffer.array();
            }

            @Override
            public int arrayOffset() {
                return byteBuffer.arrayOffset();
            }

            @Override
            public int position() {
                return byteBuffer.position();
            }

            @Override
            public AllocatedBuffer position(int n) {
                Java8Compatibility.position(byteBuffer, n);
                return this;
            }

            @Override
            public int limit() {
                return byteBuffer.limit();
            }

            @Override
            public int remaining() {
                return byteBuffer.remaining();
            }
        };
    }

    private static AllocatedBuffer wrapNoCheck(final byte[] byArray, final int n, final int n2) {
        return new AllocatedBuffer(){
            private int position;

            @Override
            public boolean hasNioBuffer() {
                return false;
            }

            @Override
            public ByteBuffer nioBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasArray() {
                return true;
            }

            @Override
            public byte[] array() {
                return byArray;
            }

            @Override
            public int arrayOffset() {
                return n;
            }

            @Override
            public int position() {
                return this.position;
            }

            @Override
            public AllocatedBuffer position(int n3) {
                if (n3 < 0 || n3 > n2) {
                    throw new IllegalArgumentException("Invalid position: " + n3);
                }
                this.position = n3;
                return this;
            }

            @Override
            public int limit() {
                return n2;
            }

            @Override
            public int remaining() {
                return n2 - this.position;
            }
        };
    }
}

