/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.MWStructInfo;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryConstructor;
import com.mathworks.mps.client.internal.MWStructToBeanFactorySetter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MWStructToBeanFactoryMaker {
    private static Class constructorPropertiesClass;
    private static Method constructorPropertiesValue;

    public static List<MWStructToBeanFactory> createFactoryList(Class clazz) {
        ArrayList<MWStructToBeanFactory> arrayList = new ArrayList<MWStructToBeanFactory>();
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        if (MWStructToBeanFactoryMaker.isStructConvertibleUsingSetters(clazz, hashMap, hashMap2)) {
            List<String> list = Arrays.asList(hashMap2.keySet().toArray(new String[hashMap2.keySet().size()]));
            arrayList.add(new MWStructToBeanFactorySetter(clazz, list, hashMap, hashMap2));
        } else {
            List<Constructor> list = MWStructToBeanFactoryMaker.getConstructorsWithValidConstructorPropertiesAnnotation(clazz);
            ArrayList<MWStructInfo> arrayList2 = new ArrayList<MWStructInfo>();
            for (Constructor constructor : list) {
                Map<String, Class> map = MWStructToBeanFactoryMaker.getAnnotationNamesToConstrArgumentTypesMap(constructor);
                List<String> list2 = Arrays.asList(map.keySet().toArray(new String[map.keySet().size()]));
                MWStructInfo mWStructInfo = new MWStructInfo(list2);
                if (arrayList2.contains(mWStructInfo)) {
                    throw new IllegalArgumentException("Found a Java type : " + clazz.getName() + ", with more than one constructors with same values for ConstructorProperties annotation.\nThis is an error because this type can be used as a target type for a MATLAB structure and cause ambiguity\nwhile marshaling the output from MATLAB.");
                }
                arrayList2.add(mWStructInfo);
                arrayList.add(new MWStructToBeanFactoryConstructor(clazz, list2, map, constructor));
            }
        }
        return arrayList;
    }

    private static boolean isStructConvertibleUsingSetters(Class clazz, Map<String, Class> map, Map<String, Method> map2) {
        if (MWStructToBeanFactoryMaker.hasDefaultConstructor(clazz)) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
                    return false;
                }
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                    String string = propertyDescriptor.getDisplayName();
                    Method method = propertyDescriptor.getWriteMethod();
                    if (method == null) continue;
                    map2.put(string, method);
                    map.put(string, propertyDescriptor.getPropertyType());
                }
                return map2.size() > 0;
            }
            catch (IntrospectionException introspectionException) {
                return false;
            }
        }
        return false;
    }

    private static boolean hasDefaultConstructor(Class clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static Map<String, Class> getAnnotationNamesToConstrArgumentTypesMap(Constructor constructor) {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        String[] stringArray = MWStructToBeanFactoryMaker.getConstructorProperties(constructor);
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], classArray[i]);
        }
        return hashMap;
    }

    private static List<Constructor> getConstructorsWithValidConstructorPropertiesAnnotation(Class clazz) {
        Constructor<?>[] constructorArray;
        ArrayList<Constructor> arrayList = new ArrayList<Constructor>();
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            String[] stringArray = MWStructToBeanFactoryMaker.getConstructorProperties(constructor);
            if (stringArray == null) continue;
            Class<?>[] classArray = constructor.getParameterTypes();
            if (stringArray.length <= 0 || classArray.length != stringArray.length) continue;
            arrayList.add(constructor);
        }
        return arrayList;
    }

    static String[] getConstructorProperties(Constructor constructor) {
        Object t;
        if (constructorPropertiesClass != null && (t = constructor.getAnnotation(constructorPropertiesClass)) != null) {
            try {
                String[] stringArray = (String[])constructorPropertiesValue.invoke(t, new Object[0]);
                return stringArray;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    static {
        try {
            constructorPropertiesClass = Class.forName("java.beans.ConstructorProperties");
            constructorPropertiesValue = constructorPropertiesClass.getMethod("value", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            constructorPropertiesClass = null;
            constructorPropertiesValue = null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

