/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWDefaultMarshalingRules;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWHttpClientDefaultConfig;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.MWSSLDefaultConfig;
import com.mathworks.mps.client.internal.ApacheFevalHandler;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.ComponentProxy;
import com.mathworks.mps.client.internal.IdentifyDispatcher;
import com.mathworks.mps.client.internal.InterfaceValidator;
import com.mathworks.mps.client.internal.MWClientInvocationHandler;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.MWLoggerFactory;
import com.mathworks.mps.client.internal.SunHttpClientFevalHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.UUID;
import org.slf4j.Logger;

public class MWHttpClient
implements MWClient {
    private final MWFevalHandler fevalHandler;
    private final MWHttpClientConfig clientConfig;
    private final MWSSLConfig sslConfig;
    private MWClientUsageLock clientUsagelock;
    private final UUID uuid;
    public static MWLoggerFactory loggerFactory;
    private Logger LOG;

    public MWHttpClient() {
        this(new MWHttpClientDefaultConfig(), new MWSSLDefaultConfig());
    }

    public MWHttpClient(MWHttpClientConfig mWHttpClientConfig) {
        this(mWHttpClientConfig, new MWSSLDefaultConfig());
    }

    public MWHttpClient(MWSSLConfig mWSSLConfig) {
        this(new MWHttpClientDefaultConfig(), mWSSLConfig);
    }

    public MWHttpClient(MWHttpClientConfig mWHttpClientConfig, MWSSLConfig mWSSLConfig) {
        loggerFactory = new MWLoggerFactory();
        this.LOG = loggerFactory.getLogger(this.getClass());
        this.validateMWHttpClientConfig(mWHttpClientConfig);
        if (null == mWSSLConfig) {
            throw new IllegalArgumentException("Invalid value for the MWSSLConfig configuration : null");
        }
        this.clientConfig = mWHttpClientConfig;
        Object object = this.clientConfig.getMaxConnectionsPerAddress();
        if (this.clientConfig.getMaxConnectionsPerAddress() < 0) {
            object = "unlimited";
        }
        this.LOG.info("Client configuration - Maximum connections per address: {} ", object);
        this.LOG.info("Client configuration - Server response timeout (ms): {}", (Object)this.clientConfig.getTimeOutMs());
        this.LOG.info("Client configuration - Is interruptible: {}", (Object)this.clientConfig.isInterruptible());
        this.LOG.info("Client configuration - Response size limit (bytes): {}", (Object)this.clientConfig.getResponseSizeLimit());
        this.LOG.info("Client configuration - Cookies enabled: {}", (Object)this.clientConfig.isCookieEnabled());
        this.LOG.info("Client configuration - Poll on update error (async): {}", (Object)this.clientConfig.pollOnUpdateErrorAsync());
        this.sslConfig = mWSSLConfig;
        this.uuid = UUID.randomUUID();
        if (this.clientConfig.isInterruptible()) {
            ApacheHttpClient apacheHttpClient = new ApacheHttpClient(this.clientConfig, mWSSLConfig, this);
            this.fevalHandler = new ApacheFevalHandler(apacheHttpClient);
            this.clientUsagelock = new MWClientUsageLock(this.fevalHandler);
            apacheHttpClient.setClientUsageLock(this.clientUsagelock);
        } else {
            this.fevalHandler = new SunHttpClientFevalHandler(this.clientConfig, mWSSLConfig);
            this.clientUsagelock = new MWClientUsageLock(this.fevalHandler);
        }
        this.LOG.info("Client initialized with UUID: {}", (Object)this.uuid);
    }

    public MWHttpClientConfig getConfig() {
        return this.clientConfig;
    }

    public MWSSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public UUID getClientUUID() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createProxy(URL uRL, Class<T> clazz) {
        this.clientUsagelock.usageEnter("This instance of MWHttpClient is in the closed state.\nOnce closed, an instance of MWHttpClient cannot be used to create a proxy instance.\nYou will have to create a new instance of MWHttpClient.");
        try {
            InterfaceValidator.validateInterface(clazz);
            Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new MWClientInvocationHandler(IdentifyDispatcher.buildMethodToDispatcherMap(uRL, clazz, this)));
            return (T)object;
        }
        finally {
            this.clientUsagelock.usageExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MWInvokable createComponentProxy(URL uRL, MWMarshalingRules mWMarshalingRules) {
        this.clientUsagelock.usageEnter("This instance of MWHttpClient is in the closed state.\nOnce closed, an instance of MWHttpClient cannot be used to create a proxy instance.\nYou will have to create a new instance of MWHttpClient.");
        try {
            ComponentProxy componentProxy = new ComponentProxy(this.fevalHandler, uRL, mWMarshalingRules, this.clientUsagelock, this);
            return componentProxy;
        }
        finally {
            this.clientUsagelock.usageExit();
        }
    }

    @Override
    public MWInvokable createComponentProxy(URL uRL) {
        this.clientUsagelock.usageEnter("This instance of MWHttpClient is in the closed state.\nOnce closed, an instance of MWHttpClient cannot be used to create a proxy instance.\nYou will have to create a new instance of MWHttpClient.");
        try {
            ComponentProxy componentProxy = new ComponentProxy(this.fevalHandler, uRL, new MWDefaultMarshalingRules(), this.clientUsagelock, this);
            return componentProxy;
        }
        finally {
            this.clientUsagelock.usageExit();
        }
    }

    @Override
    public void close() {
        this.LOG.info("Closing client - UUID: {}", (Object)this.uuid);
        this.clientUsagelock.attemptToClose();
    }

    private void validateMWHttpClientConfig(MWHttpClientConfig mWHttpClientConfig) {
        if (null == mWHttpClientConfig) {
            throw new IllegalArgumentException("Invalid value for the MWHttpClient configuration : null");
        }
        if (mWHttpClientConfig.getTimeOutMs() <= 0L) {
            throw new IllegalArgumentException("Timeout for the MWHttpClient configuration must be greater than 0");
        }
        if (mWHttpClientConfig.getMaxConnectionsPerAddress() <= 0 && mWHttpClientConfig.isInterruptible()) {
            throw new IllegalArgumentException("Maximum number of connections per address for the MWHttpClient configuration must be greater than 0 for interruptible MWHttpClient configuration");
        }
        if (!mWHttpClientConfig.isInterruptible() && mWHttpClientConfig.getMaxConnectionsPerAddress() != -1) {
            throw new IllegalArgumentException("Currently, only interruptible MWHttpClient configuration supports maximum connections per address property.\nFor non-interruptible MWHttpClient configurations, please return -1 to indicate unsupported property.");
        }
    }

    @Override
    public String getID() {
        return this.uuid.toString();
    }
}

