/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.Message;
import com.mathworks.google.protobuf.RpcCallback;

public final class RpcUtil {
    private RpcUtil() {
    }

    public static <Type extends Message> RpcCallback<Type> specializeCallback(RpcCallback<Message> rpcCallback) {
        return rpcCallback;
    }

    public static <Type extends Message> RpcCallback<Message> generalizeCallback(final RpcCallback<Type> rpcCallback, final Class<Type> clazz, final Type Type2) {
        return new RpcCallback<Message>(){

            @Override
            public void run(Message message) {
                Message message2;
                try {
                    message2 = (Message)clazz.cast(message);
                }
                catch (ClassCastException classCastException) {
                    message2 = RpcUtil.copyAsType(Type2, message);
                }
                rpcCallback.run(message2);
            }
        };
    }

    private static <Type extends Message> Type copyAsType(Type Type2, Message message) {
        return (Type)Type2.newBuilderForType().mergeFrom(message).build();
    }

    public static <ParameterType> RpcCallback<ParameterType> newOneTimeCallback(final RpcCallback<ParameterType> rpcCallback) {
        return new RpcCallback<ParameterType>(){
            private boolean alreadyCalled = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ParameterType ParameterType) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (this.alreadyCalled) {
                        throw new AlreadyCalledException();
                    }
                    this.alreadyCalled = true;
                }
                rpcCallback.run(ParameterType);
            }
        };
    }

    public static final class AlreadyCalledException
    extends RuntimeException {
        private static final long serialVersionUID = 5469741279507848266L;

        public AlreadyCalledException() {
            super("This RpcCallback was already called and cannot be called multiple times.");
        }
    }
}

