# Copyright 2014-2024 MathWorks, Inc.

import warnings

# Usage of pip is encouraged, but the "setup.py install" workflow is still supported, so 
# this script suppresses related warnings.
warnings.filterwarnings('ignore', message='.*Use build and pip and other standards-based tools.*')

firstExceptionMessage = ''
secondExceptionMessage = ''

try:
    from setuptools import setup
except Exception as firstE:
    firstExceptionMessage = str(firstE)

if firstExceptionMessage:
    try:
        # We suppress warnings about deprecation of distutils. If neither is found,
        # we will only mention setuptools, which is the one that should be used.
        warnings.filterwarnings('ignore', message='.*distutils package is deprecated.*', 
            category=DeprecationWarning)
        from distutils.core import setup
    except Exception as secondE:
        secondExceptionMessage = str(secondE)

if secondExceptionMessage:
    raise EnvironmentError("Installation failed. Install setuptools using 'python -m pip install setuptools', then try again.")

import importlib

if __name__ == '__main__':
    installModules = []
    # g2753074: When dependency on "six" is removed, this block can be removed.
    try:
        six = importlib.import_module('six')
        sixVersion = '1.12.0'
        if hasattr(six, '__version__') and sixVersion > six.__version__:
            installModules.append('six')
    except ImportError:
        installModules.append('six')

    try:
        # setup.py install with setuptools will install a .egg file, which is zipped.
        # This makes some of the C++ modules unimportable.
        # Setting zip_safe to False installs the package unzipped.
        setup(
            name="MPS Python Client",
            version="9.13",   # suggested versioning system based on R2022b release
            description='A module to invoke MATLAB function deployed on MPS from Python',
            author='MathWorks',
            url='http://www.mathworks.com/',
            zip_safe=False,
            platforms=['Linux', 'Windows', 'macOS'],
            package_dir={'': 'dist'},
            packages=['matlab',
                'matlab.production_server', 'matlab.production_server._internal_mps', 
                'matlab.production_server._proto_generated', 
                'google', 'google.protobuf_ml', 
                'google.protobuf_ml.internal'],
            package_data={'matlab': ['extern/bin/*/*', 'bin/*/*']},
            py_modules=installModules,
        )

    except:
        setup(
            name="MPS Python Client",
            version="9.13",   # suggested versioning system based on R2022b release
            description='A module to invoke MATLAB function deployed on MPS from Python',
            author='MathWorks',
            url='http://www.mathworks.com/',
            platforms=['Linux', 'Windows', 'macOS'],
            package_dir={'': 'dist'},
            packages=['matlab',
                'matlab.production_server', 'matlab.production_server._internal_mps', 
                'matlab.production_server._proto_generated', 
                'google', 'google.protobuf_ml', 
                'google.protobuf_ml.internal'],
            package_data={'matlab': ['extern/bin/*/*', 'bin/*/*']},
            py_modules=installModules,
        )
