// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

#ifndef GOOGLE_PROTOBUF_PYTHON_CPP_FIELD_H__
#define GOOGLE_PROTOBUF_PYTHON_CPP_FIELD_H__

#define PY_SSIZE_T_CLEAN
#include <Python.h>

PROTOBUF_NAMESPACE_OPEN // Modified by MathWorks, 08/25/21: Wrapping Protobuf in extra 'inline namespace mathworks'

class FieldDescriptor;

namespace python {

// A data descriptor that represents a field in a Message class.
struct PyMessageFieldProperty {
  PyObject_HEAD;

  // This pointer is owned by the same pool as the Message class it belongs to.
  const FieldDescriptor* field_descriptor;
};

extern PyTypeObject* CFieldProperty_Type;

PyObject* NewFieldProperty(const FieldDescriptor* field_descriptor);

}  // namespace python
PROTOBUF_NAMESPACE_CLOSE // Modified by MathWorks, 08/25/21: Wrapping Protobuf in extra 'inline namespace mathworks'

#endif  // GOOGLE_PROTOBUF_PYTHON_CPP_FIELD_H__
