package com.mathworks;

import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWHttpClient;

import java.io.IOException;
import java.net.URL;

interface CallDeployed {
    double[] predictFunction(double[][] students) throws IOException, MATLABException;
}

public class PredictFunctionLinearData {

    public static void main(String[] args) {

        //Csv file is read and data is prepared as per the expected format
        double[][] inputs = Utils.prepareDataForMatrixInput();

        // Create a non-interruptible MWHttpClient instance
        MWClient client = new MWHttpClient();

        try {
            // Create the proxy object that represents predictFunctionMatrixInput.ctf
            CallDeployed s = client.createProxy(new URL("http://localhost:9910/DeployedRegressionModel"), CallDeployed.class);

            // The proxy object has predictFunctionMatrixInput as one of its public methods. Invocation of predictFunctionMatrixInput
            // results in a server request that gets the results in response
            double[] objects = s.predictFunction(inputs); //Change to String[]
            for (int j = 0; j < objects.length; j++) {
                System.out.println(objects[j]);
            }

        } catch (MATLABException ex) {

            // This exception represents errors in MATLAB and provides useful information
            // like the MATLAB stack trace or the error ID associated with this error.
            System.out.println(ex);
        } catch (IOException ex) {

            // This exception can represent network issues. It is also thrown when the
            // HTTP response received from the server has a status of 4XX or 5XX
            System.out.println(ex);
        } finally {

            // We should close the client when we know that we are not going to need it any more
            // Once the client is closed, an exception will be thrown if a MATLAB function is
            // invoked using the proxy object that was created using client.
            client.close();
        }
    }
}
