// Copyright 1984-2020 The MathWorks, Inc.
// All Rights Reserved.

using System;
using System.Net;
using System.IO;
using MathWorks.MATLAB.ProductionServer.Client;
using System.Collections.Generic;

namespace SortStudents
{
    class Student
    {
        public string name;
        private string gr;
        private int sc;

        public string grade
        {
            get { return gr; }
            set { gr = value; }
        }

        public int score
        {
            get { return sc; }
            set { sc = value; }
        }

        public override string ToString()
        {
            return name + " : " + grade + " : " + score;
        }


    }

    class StudentMarshaler : MWDefaultMarshalingRules
    {
        public override IList<Type> StructTypes
        {
            get
            {
                return new List<Type> { typeof(Student) };
            }
        }
    }
    public class SortStudents
    {
        static void Main(String[] args)
        {
            Student s1 = new Student();
            s1.name = "Tony Miller";
            s1.score = 90;
            s1.grade = "A";

            Student s2 = new Student();
            s2.name = "Ed Plum";
            s2.score = 80;
            s2.grade = "B+";

            Student s3 = new Student();
            s3.name = "Mark Jones";
            s3.score = 85;
            s3.grade = "A-";

            Student[] unsorted = new Student[] { s1, s2, s3 };

            MWClient client = new MWHttpClient();

            try
            {
                //URL of the MATLAB Production Server.
                Uri archiveURL = new Uri("http://localhost:9910/sortstudents");
                MWInvokable myProxy = client.CreateComponentProxy(archiveURL, new StudentMarshaler());

                Student[] result = myProxy.Invoke<Student[]>("sortstudents", new object[] { unsorted });

                //Printing the sorted Student Array.
                PrintStudent(result);
            }
            catch (MATLABException ex)
            {
                Console.WriteLine("MATLAB error thrown : ");
                Console.WriteLine(ex.MATLABIdentifier);
                Console.WriteLine(ex.MATLABStackTraceString);
            }
            catch (WebException ex)
            {
                HttpWebResponse response = (HttpWebResponse)ex.Response;
                if (response != null)
                {
                    Console.WriteLine("Status code : " + response.StatusCode);
                    Console.WriteLine("Status description : " + response.StatusDescription);
                }
                else
                {
                    Console.WriteLine("No response received in WebException with status : " + ex.Status);
                }
            }
            finally
            {
                if (client != null)
                {
                    client.Dispose();
                }
            }

        }

        static void PrintStudent(Student[] students)
        {
            foreach (Student s in students)
            {
                Console.WriteLine(s.ToString());
            }

        }
    }
}
