﻿using MathWorks.MATLAB.ProductionServer.Client;
using System;
using System.Net;

namespace ProdServerExamples
{
    public interface ICallMethod
    {
        double[] predictFunction(double[,] inputs);
    }
    public class PredictFunctionLinearData
    {
        static void Main(String[] args)
        {

			//Csv file is read and data is prepared as per the expected format
            double[,] inpRows = Utils.PrepareDataForMatrixInput();
			
			// Create a non-interruptible MWHttpClient instance
            MWClient client = new MWHttpClient();

            try
            {
				// Create the proxy object that represents DeployedRegressionModel
                ICallMethod mSq = client.CreateProxy<ICallMethod>(new Uri("http://localhost:9910/DeployedRegressionModel"));
				
				// The proxy object has predictFunction as one of its public methods. Invocation of predictFunction
				// results in a server request that gets the results in response				
                double[] magic = mSq.predictFunction(inpRows);
                for (int j = 0; j < magic.Length; j++)
                {
                    Console.WriteLine(magic[j]);
                }
            }
            catch (MATLABException ex)
            {
				
				// This exception represents errors in MATLAB and provides useful information
				// like the MATLAB stack trace or the error ID associated with this error.

                Console.WriteLine("MATLAB error thrown : ");
                Console.WriteLine(ex.MATLABIdentifier);
                Console.WriteLine(ex.MATLABStackTraceString);
            }
            catch (WebException ex)
            {
				// This exception can represent network issues. It is also thrown when the
				// HTTP response received from the server has a status of 4XX or 5XX

                HttpWebResponse response = (HttpWebResponse)ex.Response;
                if (response != null)
                {
                    Console.WriteLine("Status code : " + response.StatusCode);
                    Console.WriteLine("Status description : " + response.StatusDescription);
                }
                else
                {
                    Console.WriteLine("No response received in WebException with status : " + ex.Status);
                }
            }
            finally
            {
                client.Dispose();
            }
            Console.ReadLine();

        }
    }
}

