# Copyright 2014-2020 The MathWorks, Inc.
# All Rights Reserved.

from matlab.production_server import client
from matlab.production_server import mpsexceptions
import sys
import pprint

def main():
    # Create python client object, the default response timeout is 120 sec (2 mins)
    # Any custom response timeout should be specified in milliseconds    
    
    client_object = client.MWHttpClient('http://localhost:9910', timeout_ms = 60 * 1000)
    
    try:        
        # Create individual dictionaries for all students
        student1 = dict([('Name', 'Toni Miller'), ('Score', 90), ('Grade', 'A')])
        student2 = dict([('Name', 'Edward Plum'), ('Score', 80), ('Grade', 'B+')])
        student3 = dict([('Name', 'Mark Smith'), ('Score', 85), ('Grade', 'A-')])
        student4 = dict([('Name', 'Tomas Jones'), ('Score', 95), ('Grade', 'A+')])
        student5 = dict([('Name', 'Steve Taylor'), ('Score', 75), ('Grade', 'B')])               
        
        # The CTF deployed on the server is studentsorter.ctf, the MATLAB function is sortstudents
        # The MATLAB function is invoked using the python client  object as below    
        data = client_object.studentsorter.sortstudents([student1, student2, student3, student4, student5])
        
        pp = pprint.PrettyPrinter(indent = 3)
        pp.pprint(data)
        
    except mpsexceptions.MATLABException as e:
        print('MATLAB Error: ',e)
    finally:
        client_object.close()
        
if __name__ == '__main__':
    main()
    