function sorted = sortstudents(unsorted)

% Copyright 1984-2019 The MathWorks, Inc.
% All Rights Reserved.

% Receive list of dicts as a cell array
% Convert cell array to array of structs
students = cellfun(@(x) struct(x) , unsorted);
% Get scores of all the students
scores = {students.Score};
% Convert the cell array containing scores into a numeric array or doubles
scores = cell2mat(scores);
% Sort the scores array
[~, i] = sort(scores);
% Sort the students array based on the sorted scores array
sorted = unsorted(i);
