# Copyright 2014-2020 The MathWorks, Inc.
# All Rights Reserved.

from matlab.production_server import client
from matlab.production_server import mpsexceptions
import sys

def main(source = 'The quick brown fox jumps over the lazy dog', pattern = 'jumps'):
    # Create python client object. The default response timeout is 120 sec (2 mins).
    # Any custom response timeout should be specified in milliseconds.
    client_object = client.MWHttpClient('http://localhost:9910')
    
    try:                
        # The CTF deployed on the server is substring.ctf. The MATLAB function is getsubstring.
        # Invoke the MATLAB function using the python client object.
        # Multiple output arguments are specified by setting the nargout value as below.
        substring1, substring2 = client_object.substring.getsubstring(source, pattern, nargout = 2)
                
        print(substring1)        
        print(substring2)
        
    except mpsexceptions.MATLABException as e:
        print('MATLAB Error: ',e)
    finally:
        client_object.close()
        
if __name__ == '__main__':
    main()