/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.message.BasicHeaderElementIterator;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.MATLABRequestInfo;
import com.mathworks.mps.client.internal.MATLABRequestNotification;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.InstanceInfo;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;

public class RequestNotificationsCallback<T>
implements FutureCallback<HttpResponse> {
    private final ApacheHttpClient httpClient;
    private final InstanceInfo instance;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
    private int retryCnt;
    private boolean pollOnUpdateError;

    public RequestNotificationsCallback(InstanceInfo instanceInfo, ApacheHttpClient apacheHttpClient) {
        this.httpClient = apacheHttpClient;
        this.instance = instanceInfo;
        this.retryCnt = 0;
        this.pollOnUpdateError = apacheHttpClient.getMWClient().getConfig().pollOnUpdateErrorAsync();
    }

    @Override
    public void cancelled() {
        this.LOG.trace("Server state update request cancelled: {}", (Object)this.instance.getHttpContext().getRequest().getRequestLine());
        this.instance.setNotificationRunningFalse();
        this.httpClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(HttpResponse httpResponse) {
        try {
            if (this.httpClient.getClientUsageLock().wasAttemptedToClose()) {
                this.instance.setNotificationRunningFalse();
                return;
            }
            this.retryCnt = 0;
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n == 200) {
                String string = "";
                BasicHeaderElementIterator basicHeaderElementIterator = new BasicHeaderElementIterator(httpResponse.headerIterator("X-MPS-Start-Time"));
                if (basicHeaderElementIterator.hasNext()) {
                    string = basicHeaderElementIterator.nextElement().getName();
                }
                if (!string.equals(this.instance.getSessionId())) {
                    this.LOG.trace("Server instance session ID was changed - New session ID: {} , Old session ID: {}", (Object)string, (Object)this.instance.getSessionId());
                    this.failAllRequests(new IOException("MPS instance has been restarted"));
                    this.httpClient.requestsCreated.remove(this.instance.getSessionId());
                    this.instance.updateSessionId(string);
                }
                try {
                    MATLABRequestNotification.MATLAB_Request_Notification mATLAB_Request_Notification = this.httpClient.parseRequestNotification(httpResponse);
                    this.instance.setCurrentSeq(mATLAB_Request_Notification.getCurrentTime());
                    List<MATLABRequestNotification.MATLAB_Request_Notification.UpdateInfo> list = mATLAB_Request_Notification.getUpdatedList();
                    this.LOG.debug("Server state updates - Number of requests updated: {}", (Object)list.size());
                    for (MATLABRequestNotification.MATLAB_Request_Notification.UpdateInfo updateInfo : list) {
                        String string2 = updateInfo.getUrl();
                        MATLABRequestInfo.MATLAB_Request_Info mATLAB_Request_Info = updateInfo.getInfo();
                        this.LOG.debug("Request update info - url: {}, last_modified: {}, state: {}", string2, mATLAB_Request_Info.getLastModified(), mATLAB_Request_Info.getState());
                        this.httpClient.updateRequest(string2, mATLAB_Request_Info, string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.httpClient.executeGetForNotifications(this.instance);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.failAllRequests(uRISyntaxException);
            this.LOG.trace("Exiting update loop for instance : {}", (Object)this.instance);
            this.instance.setNotificationRunningFalse();
        }
        finally {
            this.httpClient.getClientUsageLock().usageExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception exception) {
        this.LOG.debug("Server state update request failed: ", exception);
        try {
            if (this.httpClient.getClientUsageLock().wasAttemptedToClose()) {
                this.instance.setNotificationRunningFalse();
                return;
            }
            if (exception instanceof SocketTimeoutException) {
                this.LOG.debug("SocketTimeoutException received. This implies long running MATLAB code. Sending update request immediately.");
            } else if (this.pollOnUpdateError) {
                ++this.retryCnt;
                long l = (long)(500.0 * Math.pow(2.0, this.retryCnt));
                if (l > 120000L) {
                    l = 120000L;
                }
                try {
                    this.LOG.debug("Connectivity issues with server instance. Sleeping for {} ms", (Object)l);
                    this.instance.getWaitNotifier().sleepFor(Duration.ofMillis(l));
                }
                catch (CancellationException cancellationException) {
                    this.LOG.trace("Update thread's sleep, as part of its wait to reestablish server connectivity, was cancelled.");
                    this.instance.getWaitNotifier().reset();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    this.LOG.trace("Update thread was interrupted as it was sleeping as part of its wait to reestablish server connectivity.");
                    this.instance.setNotificationRunningFalse();
                    this.httpClient.getClientUsageLock().usageExit();
                    return;
                }
            } else {
                this.failAllRequests(exception);
            }
            this.httpClient.executeGetForNotifications(this.instance);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.failAllRequests(exception);
            this.LOG.trace("Exiting update loop for instance : {}", (Object)this.instance);
            this.instance.setNotificationRunningFalse();
        }
        finally {
            this.httpClient.getClientUsageLock().usageExit();
        }
    }

    private void failAllRequests(Exception exception) {
        for (MWRequestImpl mWRequestImpl : this.httpClient.requestsCreated.get(this.instance.getSessionId()).values()) {
            this.LOG.trace("Moving request to failed state due to error while seeking request updates : {}", (Object)mWRequestImpl.getRequestURL());
            mWRequestImpl.updateStateAndNotify(new FailedMWRequestState(exception));
        }
    }
}

