/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.client.methods.HttpGet;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.client.methods.HttpUriRequest;
import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.MWRequestState;
import com.mathworks.mps.client.MWRequestStateVisitor;
import com.mathworks.mps.client.internal.ApacheFevalHandler;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.async.CancelledMWRequestState;
import com.mathworks.mps.client.internal.async.FutureVisitor;
import com.mathworks.mps.client.internal.async.InQueueMWRequestState;
import com.mathworks.mps.client.internal.async.InterruptedMWRequestState;
import com.mathworks.mps.client.internal.async.MWFuture;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.ProcessingMWRequestState;
import com.mathworks.mps.client.internal.async.SendingMWRequestState;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class MWRequestImpl<T>
implements MWRequest<T> {
    private MWRequestState<T> state;
    private MWRequestListener<T> listener = null;
    private final MWFuture<T> future;
    private final MWClient client;
    private final MWRequestStateVisitor<T> visitor;
    private final MWRequestInfo<T> clientRequestInfo;
    private ApacheFevalHandler fevalHandler;
    private ApacheHttpClient apacheClient;
    private UUID tempId;
    public final Object lock = new Object();
    public boolean markedForCancellation = false;
    public HttpUriRequest httpPost;
    public HttpUriRequest httpGetResponse;
    public HttpUriRequest httpGetError;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MWRequestImpl(MWClient mWClient, MWRequestListener<T> mWRequestListener, MWRequestInfo<T> mWRequestInfo, ApacheFevalHandler apacheFevalHandler) {
        this.future = new MWFuture(this);
        this.client = mWClient;
        this.listener = mWRequestListener;
        this.apacheClient = apacheFevalHandler.getApacheHttpClient();
        this.visitor = new FutureVisitor<T>(this.future);
        this.clientRequestInfo = mWRequestInfo;
        this.fevalHandler = apacheFevalHandler;
        this.tempId = UUID.randomUUID();
    }

    @Override
    public void release() {
        if (this.fevalHandler.isClosed()) {
            throw new IllegalStateException("MWHttpClient that provided the proxy object has already been closed");
        }
        if (!this.state.isTerminal()) {
            throw new IllegalStateException("A request has to be in a terminal state to be released.");
        }
        if (this.clientRequestInfo == null || this.clientRequestInfo.getRequestUrl() == null) {
            return;
        }
        String string = this.clientRequestInfo.getInstance().getServerUri() + this.clientRequestInfo.getRequestUrl();
        this.apacheClient.executeDelete(string, this.clientRequestInfo.getInstance().getHttpContext());
    }

    @Override
    public Future<T> getFuture() {
        return this.future;
    }

    @Override
    public MWRequestState<T> getState() {
        return this.state;
    }

    @Override
    public MWClient getClient() {
        return this.client;
    }

    public MWRequestInfo<T> getClientRequestInfo() {
        return this.clientRequestInfo;
    }

    public MWRequestStateVisitor<T> getFutureVisitor() {
        return this.visitor;
    }

    public UUID getTempId() {
        return this.tempId;
    }

    public void markReadingResponse(HttpGet httpGet) {
        this.httpGetResponse = httpGet;
    }

    public void markReadingError(HttpGet httpGet) {
        this.httpGetError = httpGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCreated() {
        Object object = this.lock;
        synchronized (object) {
            this.httpPost = null;
            this.apacheClient.pendingRequests.remove(this.tempId);
        }
    }

    private boolean isValidUpdateRequest(MWRequestState<T> mWRequestState) {
        boolean bl = false;
        StateComparator<T> stateComparator = new StateComparator<T>();
        if (stateComparator.compare(this.state, mWRequestState) == -1) {
            bl = true;
        }
        return bl;
    }

    private boolean setState(MWRequestState<T> mWRequestState) {
        boolean bl = this.isValidUpdateRequest(mWRequestState);
        if (bl) {
            this.state = mWRequestState;
            mWRequestState.visit(this.visitor);
        }
        return bl;
    }

    private void notifyListeners() {
        if (this.listener != null) {
            this.listener.notify(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateAndNotify(MWRequestState<T> mWRequestState) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            bl = this.setState(mWRequestState);
        }
        if (bl) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state.isTerminal()) {
                return false;
            }
            if (this.state.getClass() == SendingMWRequestState.class) {
                this.markedForCancellation = true;
            } else {
                this.sendCancelRequest();
            }
            this.setState(new CancelledMWRequestState());
        }
        this.notifyListeners();
        return true;
    }

    public void sendCancelRequest() {
        String string = this.clientRequestInfo.getInstance().getServerUri() + this.clientRequestInfo.getRequestUrl() + "/cancel";
        this.apacheClient.executePostCancel(new HttpPost(string), null, this.clientRequestInfo.getInstance().getHttpContext(), null);
        String string2 = this.clientRequestInfo.getRequestUrl();
        String string3 = this.clientRequestInfo.getInstance().getSessionId();
        this.apacheClient.requestsCreated.get(string3).remove(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.httpPost != null) {
                this.httpPost.abort();
                bl = this.setState(new InterruptedMWRequestState());
            }
        }
        if (bl) {
            this.notifyListeners();
        }
    }

    public String toString() {
        if (this.clientRequestInfo == null || this.clientRequestInfo.getInstance() == null) {
            return null;
        }
        return this.clientRequestInfo.getInstance().getServerUri() + this.clientRequestInfo.getRequestUrl();
    }

    @Override
    public String getRequestURL() {
        return this.clientRequestInfo == null ? null : this.clientRequestInfo.getRequestUrl();
    }

    private class StateComparator<T>
    implements Comparator<MWRequestState<T>> {
        private StateComparator() {
        }

        @Override
        public int compare(MWRequestState<T> mWRequestState, MWRequestState<T> mWRequestState2) {
            if (mWRequestState == null) {
                return -1;
            }
            if (mWRequestState2.getClass() == InterruptedMWRequestState.class && (MWRequestImpl.this.httpGetResponse != null || MWRequestImpl.this.httpGetError != null)) {
                return 1;
            }
            Class<?> clazz = mWRequestState.getClass();
            if (clazz == mWRequestState2.getClass()) {
                return 0;
            }
            if (mWRequestState.isTerminal() && !mWRequestState2.isTerminal()) {
                return 1;
            }
            if (clazz == SendingMWRequestState.class ? mWRequestState2.isTerminal() || mWRequestState2.getClass() == ProcessingMWRequestState.class || mWRequestState2.getClass() == InQueueMWRequestState.class || mWRequestState2.getClass() == InterruptedMWRequestState.class : (clazz == InQueueMWRequestState.class ? mWRequestState2.isTerminal() || mWRequestState2.getClass() == ProcessingMWRequestState.class || mWRequestState2.getClass() == InterruptedMWRequestState.class : clazz == ProcessingMWRequestState.class && (mWRequestState2.isTerminal() || mWRequestState2.getClass() == InterruptedMWRequestState.class))) {
                return -1;
            }
            return 1;
        }
    }
}

