/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.RequestLine;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.message.BasicHeaderElementIterator;
import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.MATLABRequestCreated;
import com.mathworks.mps.client.internal.MATLABRequestInfo;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.ResponseProducer;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.ReadyMWRequestState;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;

public class HttpResponseCallback<T>
implements FutureCallback<HttpResponse> {
    private final String serverUri;
    private final MWRequestInfo<T> clientRequestInfo;
    private MWRequestImpl<T> request;
    private final ApacheHttpClient httpClient;
    private final Logger LOG;
    private HttpClientContext httpContext;

    public HttpResponseCallback(String string, MWRequestImpl<T> mWRequestImpl, ApacheHttpClient apacheHttpClient, HttpClientContext httpClientContext) {
        this.request = mWRequestImpl;
        this.clientRequestInfo = mWRequestImpl.getClientRequestInfo();
        this.httpClient = apacheHttpClient;
        this.serverUri = string;
        this.LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
        this.httpContext = httpClientContext;
    }

    @Override
    public void cancelled() {
        this.LOG.trace("Request cancelled: {}", (Object)this.httpContext.getRequest().getRequestLine());
        this.httpClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void completed(HttpResponse httpResponse) {
        int n = httpResponse.getStatusLine().getStatusCode();
        try {
            if (n == 200) {
                try {
                    Object object = this.request.lock;
                    synchronized (object) {
                        if (this.request.markedForCancellation) {
                            return;
                        }
                    }
                    object = this.clientRequestInfo.getResponseBuilder();
                    MATLABResult.MATLAB_Result mATLAB_Result = this.httpClient.parseMATLABResult(httpResponse);
                    ((ResponseProducer)object).checkMLResultForErrors(mATLAB_Result);
                    Object object2 = ((ResponseProducer)object).createMATLABResponse(mATLAB_Result);
                    this.LOG.debug("Received MATLAB result for request: {}", (Object)this.request.getClientRequestInfo().getRequestUrl());
                    this.request.updateStateAndNotify(new ReadyMWRequestState<Object>(object2, this.clientRequestInfo));
                    return;
                }
                catch (IOException iOException) {
                    this.request.updateStateAndNotify(new FailedMWRequestState(iOException));
                    return;
                }
                catch (MATLABException mATLABException) {
                    this.request.updateStateAndNotify(new FailedMWRequestState(mATLABException));
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        this.request.updateStateAndNotify(new FailedMWRequestState(exception));
                        return;
                    }
                }
                finally {
                    String string = this.request.getClientRequestInfo().getRequestUrl();
                    this.LOG.trace("Deleting request since it has reached terminal state: {}", (Object)string);
                    if (string != null) {
                        String string2 = this.request.getClientRequestInfo().getInstance().getSessionId();
                        this.httpClient.requestsCreated.get(string2).remove(string);
                    } else {
                        this.httpClient.pendingRequests.remove(this.request.getTempId());
                    }
                }
            }
            if (n == 201) {
                if (this.httpClient.getClientUsageLock().wasAttemptedToClose()) {
                    return;
                }
                this.httpClient.pendingRequests.remove(this.request.getTempId());
                {
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                BasicHeaderElementIterator basicHeaderElementIterator = new BasicHeaderElementIterator(httpResponse.headerIterator("X-MPS-Start-Time"));
                String string = "";
                if (basicHeaderElementIterator.hasNext()) {
                    string = basicHeaderElementIterator.nextElement().getName();
                }
                BasicHeaderElementIterator basicHeaderElementIterator2 = new BasicHeaderElementIterator(httpResponse.headerIterator("Location"));
                String string3 = basicHeaderElementIterator2.nextElement().getName();
                UUID uUID = this.parseInstanceUUID(string3);
                MATLABRequestCreated.MATLAB_Request_Created mATLAB_Request_Created = this.httpClient.parseMATLABRequest(httpResponse);
                MWRequestInfo<T> mWRequestInfo = this.request.getClientRequestInfo();
                mWRequestInfo.setSubscriptionURL(mATLAB_Request_Created.getSubscriptionUrl());
                mWRequestInfo.setRequestUrl(string3);
                this.httpClient.registerRequest(this.request, uUID, this.serverUri, string, this.httpContext);
                Object object = this.request.lock;
                synchronized (object) {
                    if (this.request.markedForCancellation) {
                        this.request.sendCancelRequest();
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 16, 28, 13] lbl67 : MonitorExitStatement: MONITOREXIT : var10_28
                    object = mATLAB_Request_Created.getInfo();
                    MATLABRequestInfo.MATLAB_Request_Info mATLAB_Request_Info = this.httpClient.pendingNotifications.remove(string3);
                    Object object3 = mATLAB_Request_Info == null ? object : mATLAB_Request_Info;
                    this.httpClient.updateRequest(string3, (MATLABRequestInfo.MATLAB_Request_Info)object3, string);
                    return;
                }
            }
            this.request.updateStateAndNotify(new FailedMWRequestState(new MWHttpException(n, httpResponse.getStatusLine().getReasonPhrase())));
            return;
        }
        finally {
            this.httpClient.getClientUsageLock().usageExit();
        }
    }

    private UUID parseInstanceUUID(String string) {
        String[] stringArray = string.split("/");
        return UUID.fromString(stringArray[1].substring(1));
    }

    @Override
    public void failed(Exception exception) {
        if (this.httpContext.getRequest() != null) {
            RequestLine requestLine = this.httpContext.getRequest().getRequestLine();
            this.LOG.trace("Request failed: {}", (Object)(requestLine.getMethod() + " " + this.serverUri + requestLine.getUri()));
        }
        this.httpClient.getClientUsageLock().usageExit();
        this.request.updateStateAndNotify(new FailedMWRequestState(exception));
    }
}

