/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.internal.AbstractHttpClientFevalHandler;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.internal.MWSSLContext;
import com.mathworks.mps.client.internal.ResponseProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;

public class SunHttpClientFevalHandler
extends AbstractHttpClientFevalHandler {
    private final MWSSLConfig sslConfig;
    private final int connectTimeOutMs;
    private final int readTimeOutMs;
    private final SSLSocketFactory sslSocketFactory;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public SunHttpClientFevalHandler(MWHttpClientConfig mWHttpClientConfig, MWSSLConfig mWSSLConfig) {
        super(mWHttpClientConfig.getResponseSizeLimit());
        this.LOG.debug("Initializing Sun HTTP feval handler");
        this.sslConfig = mWSSLConfig;
        this.readTimeOutMs = this.connectTimeOutMs = new Long(mWHttpClientConfig.getTimeOutMs()).intValue();
        try {
            this.sslSocketFactory = mWSSLConfig.getSSLContext() == null ? MWSSLContext.getDefault().getSocketFactory() : mWSSLConfig.getSSLContext().getSocketFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException("Trouble initializing MWHttpClient", exception);
        }
        this.LOG.debug("Sun HTTP feval handler initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MATLABResult.MATLAB_Result processRequest(URL uRL, MATLABParams.MATLAB_Params mATLAB_Params) throws Throwable {
        MATLABResult.MATLAB_Result mATLAB_Result;
        Object object;
        Object object2;
        this.LOG.debug("Processing request (sync)");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("User-Agent", this.getClass().getName());
        httpURLConnection.setRequestProperty("Content-Type", "application/x-google-protobuf");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(true);
        httpURLConnection.setConnectTimeout(this.connectTimeOutMs);
        httpURLConnection.setReadTimeout(this.readTimeOutMs);
        boolean bl = this.isSecureConnection(uRL);
        if (bl) {
            object2 = (HttpsURLConnection)httpURLConnection;
            ((HttpsURLConnection)object2).setSSLSocketFactory(this.sslSocketFactory);
            object = this.sslConfig.getHostnameVerifier();
            if (object != null) {
                ((HttpsURLConnection)object2).setHostnameVerifier((HostnameVerifier)object);
            }
        }
        this.LOG.trace("Sending request (sync)");
        this.LOG.trace("Execute POST - {}", (Object)httpURLConnection);
        httpURLConnection.connect();
        if (bl) {
            try {
                MWInvocationHandlerUtils.throwIfServerIsNotAuthorized(((HttpsURLConnection)httpURLConnection).getServerCertificates(), this.sslConfig);
            }
            catch (Exception exception) {
                httpURLConnection.disconnect();
                throw exception;
            }
        }
        object2 = httpURLConnection.getOutputStream();
        try {
            mATLAB_Params.writeTo((OutputStream)object2);
            ((OutputStream)object2).flush();
        }
        finally {
            ((OutputStream)object2).close();
        }
        object = httpURLConnection.getInputStream();
        CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)object);
        codedInputStream.setSizeLimit(this.responseSizeLimit);
        try {
            this.LOG.trace("HTTP RESPONSE --------- completed: {}", (Object)httpURLConnection.getResponseMessage());
            mATLAB_Result = MATLABResult.MATLAB_Result.parseFrom(codedInputStream, (ExtensionRegistryLite)MWInvocationHandlerUtils.extRegistry);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    throw iOException;
                }
                throw new MWHttpException(n, httpURLConnection.getResponseMessage());
            }
        }
        ((InputStream)object).close();
        return mATLAB_Result;
    }

    @Override
    public <T> MWRequest<T> processRequest(URL uRL, MATLABParams.MATLAB_Params mATLAB_Params, ResponseProducer<T> responseProducer, MWRequestListener<T> mWRequestListener) {
        return null;
    }

    @Override
    public void abort() {
    }
}

