/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.CodedOutputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.google.protobuf.FieldSet;
import com.mathworks.google.protobuf.MapFieldLite;
import com.mathworks.google.protobuf.MessageLite;
import com.mathworks.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class MapEntryLite<K, V> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;

    private MapEntryLite(WireFormat.FieldType fieldType, K k, WireFormat.FieldType fieldType2, V v) {
        this.metadata = new Metadata<K, V>(fieldType, k, fieldType2, v);
        this.key = k;
        this.value = v;
    }

    private MapEntryLite(Metadata<K, V> metadata, K k, V v) {
        this.metadata = metadata;
        this.key = k;
        this.value = v;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType fieldType, K k, WireFormat.FieldType fieldType2, V v) {
        return new MapEntryLite<K, V>(fieldType, k, fieldType2, v);
    }

    static <K, V> void writeTo(CodedOutputStream codedOutputStream, Metadata<K, V> metadata, K k, V v) throws IOException {
        FieldSet.writeElement(codedOutputStream, metadata.keyType, 1, k);
        FieldSet.writeElement(codedOutputStream, metadata.valueType, 2, v);
    }

    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K k, V v) {
        return FieldSet.computeElementSize(metadata.keyType, 1, k) + FieldSet.computeElementSize(metadata.valueType, 2, v);
    }

    static <T> T parseField(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite, WireFormat.FieldType fieldType, T t) throws IOException {
        switch (fieldType) {
            case MESSAGE: {
                MessageLite.Builder builder = ((MessageLite)t).toBuilder();
                codedInputStream.readMessage(builder, extensionRegistryLite);
                return (T)builder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(codedInputStream.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(codedInputStream, fieldType, true);
    }

    public void serializeTo(CodedOutputStream codedOutputStream, int n, K k, V v) throws IOException {
        codedOutputStream.writeTag(n, 2);
        codedOutputStream.writeUInt32NoTag(MapEntryLite.computeSerializedSize(this.metadata, k, v));
        MapEntryLite.writeTo(codedOutputStream, this.metadata, k, v);
    }

    public int computeMessageSize(int n, K k, V v) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(MapEntryLite.computeSerializedSize(this.metadata, k, v));
    }

    public Map.Entry<K, V> parseEntry(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return MapEntryLite.parseEntry(byteString.newCodedInput(), this.metadata, extensionRegistryLite);
    }

    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream codedInputStream, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n;
        Object k = metadata.defaultKey;
        Object v = metadata.defaultValue;
        while ((n = codedInputStream.readTag()) != 0) {
            if (n == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                k = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, metadata.keyType, k);
                continue;
            }
            if (n == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                v = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, metadata.valueType, v);
                continue;
            }
            if (codedInputStream.skipField(n)) continue;
            break;
        }
        return new AbstractMap.SimpleImmutableEntry(k, v);
    }

    public void parseInto(MapFieldLite<K, V> mapFieldLite, CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n;
        int n2 = codedInputStream.readRawVarint32();
        int n3 = codedInputStream.pushLimit(n2);
        Object k = this.metadata.defaultKey;
        Object v = this.metadata.defaultValue;
        while ((n = codedInputStream.readTag()) != 0) {
            if (n == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                k = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, this.metadata.keyType, k);
                continue;
            }
            if (n == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                v = MapEntryLite.parseField(codedInputStream, extensionRegistryLite, this.metadata.valueType, v);
                continue;
            }
            if (codedInputStream.skipField(n)) continue;
            break;
        }
        codedInputStream.checkLastTagWas(0);
        codedInputStream.popLimit(n3);
        mapFieldLite.put(k, v);
    }

    Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        public Metadata(WireFormat.FieldType fieldType, K k, WireFormat.FieldType fieldType2, V v) {
            this.keyType = fieldType;
            this.defaultKey = k;
            this.valueType = fieldType2;
            this.defaultValue = v;
        }
    }
}

